package razgriz.news;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

import razgriz.common.eclipse.ExtensionUtil;
import razgriz.common.eclipse.ExtensionUtil.IExtensionProcessor;
import razgriz.news.clipper.NewsClipper;
import razgriz.news.clipper.NewsClipperService;
import razgriz.news.favlist.FavoriteListService;

/**
 * The main plugin class to be used in the desktop.
 */
public class NewsPlugin extends Plugin {
    public static final String ID = NewsPlugin.class.getName();

    public static final String ID_SCHEMAS_EXTENSION = "razgriz.news.clippers";

    //The shared instance.
    private static NewsPlugin plugin;
    //Resource bundle.
    private ResourceBundle resourceBundle;

    private FavoriteListService favoriteListService;
    private NewsClipperService newsClipperService;
	
    /**
     * The constructor.
     */
    public NewsPlugin() {
        super();
        plugin = this;
        try {
            resourceBundle = ResourceBundle.getBundle("razgriz.news.NewsPluginResources");
        } catch (MissingResourceException x) {
            resourceBundle = null;
        }
    }

    /**
     * This method is called upon plug-in activation
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    /**
     * This method is called when the plug-in is stopped
     */
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    /**
     * Returns the shared instance.
     */
    public static NewsPlugin getDefault() {
        return plugin;
    }

    /**
     * Returns the string from the plugin's resource bundle,
     * or 'key' if not found.
     */
    public static String getResourceString(String key) {
        ResourceBundle bundle = NewsPlugin.getDefault().getResourceBundle();
        try {
            return (bundle != null) ? bundle.getString(key) : key;
        } catch (MissingResourceException e) {
            return key;
        }
    }

    /**
     * Returns the plugin's resource bundle,
     */
    public ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    public synchronized FavoriteListService getFavoriteListService() {
        if (favoriteListService == null) {
            favoriteListService = new FavoriteListService();
        }
        return favoriteListService;
    }

    public synchronized NewsClipperService getNewsClipperService() {
        if (newsClipperService == null) {
            newsClipperService = initNewsClipperService();
        }
        return newsClipperService;
    }
    
    protected NewsClipperService initNewsClipperService() {
        NewsClipperService ret = new NewsClipperService();
        ExtensionUtil.processRegistry(
            ID_SCHEMAS_EXTENSION, new NewsClipperRegister(ret)
        );
        return ret;
    }

    class NewsClipperRegister implements IExtensionProcessor {
        NewsClipperService service;

        public NewsClipperRegister(NewsClipperService service) {
            this.service = service;
        }
        public void process(
            IExtension extension, IConfigurationElement confelem
        ) {
            try {
                String id = confelem.getAttribute("id");
                NewsClipper clipper =
                    (NewsClipper) confelem.createExecutableExtension("class");
                service.registerClipper(id, clipper);
            } catch (CoreException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
    }
}
