/*
 * Decompiled with CFR 0.152.
 */
package razgriz.news;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import razgriz.common.eclipse.ExtensionUtil;
import razgriz.news.clipper.NewsClipper;
import razgriz.news.clipper.NewsClipperService;
import razgriz.news.favlist.FavoriteListService;

public class NewsPlugin
extends Plugin {
    public static final String ID;
    public static final String ID_SCHEMAS_EXTENSION = "razgriz.news.clippers";
    private static NewsPlugin plugin;
    private ResourceBundle resourceBundle;
    private FavoriteListService favoriteListService;
    private NewsClipperService newsClipperService;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("razgriz.news.NewsPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID = clazz.getName();
    }

    public NewsPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("razgriz.news.NewsPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static NewsPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = NewsPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public synchronized FavoriteListService getFavoriteListService() {
        if (this.favoriteListService == null) {
            this.favoriteListService = new FavoriteListService();
        }
        return this.favoriteListService;
    }

    public synchronized NewsClipperService getNewsClipperService() {
        if (this.newsClipperService == null) {
            this.newsClipperService = this.initNewsClipperService();
        }
        return this.newsClipperService;
    }

    protected NewsClipperService initNewsClipperService() {
        NewsClipperService ret = new NewsClipperService();
        ExtensionUtil.processRegistry((String)ID_SCHEMAS_EXTENSION, (ExtensionUtil.IExtensionProcessor)new NewsClipperRegister(ret));
        return ret;
    }

    class NewsClipperRegister
    implements ExtensionUtil.IExtensionProcessor {
        NewsClipperService service;

        public NewsClipperRegister(NewsClipperService service) {
            this.service = service;
        }

        public void process(IExtension extension, IConfigurationElement confelem) {
            try {
                String id = confelem.getAttribute("id");
                NewsClipper clipper = (NewsClipper)confelem.createExecutableExtension("class");
                this.service.registerClipper(id, clipper);
            }
            catch (CoreException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
    }
}

