/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;

public class FileExtensionDialog
extends TitleAreaDialog {
    private String filename = "";
    private Text filenameField;
    private Button okButton;

    public FileExtensionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(WorkbenchMessages.getString("FileExtension.shellTitle"));
        WorkbenchHelp.setHelp((Control)shell, "org.eclipse.ui.file_extension_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        contents.setLayout((Layout)layout);
        contents.setLayoutData((Object)new GridData(1808));
        contents.setFont(parentComposite.getFont());
        this.setTitle(WorkbenchMessages.getString("FileExtension.dialogTitle"));
        this.setMessage(WorkbenchMessages.getString("FileExtension.fileTypeMessage"));
        Label label = new Label(contents, 16384);
        label.setText(WorkbenchMessages.getString("FileExtension.fileTypeLabel"));
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        this.filenameField = new Text(contents, 2052);
        this.filenameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (event.widget == FileExtensionDialog.this.filenameField) {
                    FileExtensionDialog.this.filename = FileExtensionDialog.this.filenameField.getText().trim();
                    FileExtensionDialog.this.okButton.setEnabled(FileExtensionDialog.this.validateFileType());
                }
            }
        });
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.filenameField.setLayoutData((Object)data);
        this.filenameField.setFocus();
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private boolean validateFileType() {
        if (this.filename.length() == 0) {
            this.setErrorMessage(null);
            return false;
        }
        int index = this.filename.indexOf(46);
        if (index == this.filename.length() - 1 && (index == 0 || index == 1 && this.filename.charAt(0) == '*')) {
            this.setErrorMessage(WorkbenchMessages.getString("FileExtension.extensionEmptyMessage"));
            return false;
        }
        index = this.filename.indexOf(42);
        if (index > -1) {
            if (this.filename.length() == 1) {
                this.setErrorMessage(WorkbenchMessages.getString("FileExtension.extensionEmptyMessage"));
                return false;
            }
            if (index != 0 || this.filename.charAt(1) != '.') {
                this.setErrorMessage(WorkbenchMessages.getString("FileExtension.fileNameInvalidMessage"));
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    public String getExtension() {
        int index = this.filename.indexOf(46);
        if (index == -1) {
            return "";
        }
        if (index == this.filename.length()) {
            return "";
        }
        return this.filename.substring(index + 1, this.filename.length());
    }

    public String getName() {
        int index = this.filename.indexOf(46);
        if (index == -1) {
            return this.filename;
        }
        if (index == 0) {
            return "*";
        }
        return this.filename.substring(0, index);
    }
}

