/*
 * Created on 2005/01/25
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

import razgriz.news.model.Group;
import razgriz.news.model.News;
import razgriz.news.model.NewsFactory;
import razgriz.news.ui.SharedImages;
import razgriz.news.ui.dialogs.BeanEditorDialog;
import razgriz.news.ui.dialogs.GroupDialogBean;

/**
 * 
 */
public class AddGroupAction extends Action {
    public static final String ID = AddGroupAction.class.getName();

    IWorkbenchSite site;
    TreeViewer viewer;

    public AddGroupAction(
        IWorkbenchSite site, TreeViewer viewer
    ) {
        super();

        this.site = site;
        this.viewer = viewer;

        setId(ID);
        setText("O[v̒ǉ");
        setToolTipText("O[vǉ܂");
        setImageDescriptor(
            PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(
                SharedImages.IMG_ACT_ADDGROUP
            )
        );
    }

    public void run() {
        IStructuredSelection sel =
            (IStructuredSelection) viewer.getSelection();

        if (sel.size() != 1) {
            throw new IllegalArgumentException(); // todo:                    
        }

        GroupDialogBean bean = new GroupDialogBean();
        BeanEditorDialog dialog = new BeanEditorDialog(
            site.getShell(),
            "O[v̒ǉ",
            "O[v̏͂Ă",
            bean,
            bean,
            bean,
            null
        );
        if (dialog.open() == InputDialog.OK) {
            Group grp = NewsFactory.eINSTANCE.createGroup();
            grp.setTitle(bean.getTitle());

            Object obj = sel.getFirstElement();
            if (obj instanceof Group) {
                Group parent = (Group) obj;
                parent.getMembers().add(grp);
            } else if (obj instanceof News) {
                News news = (News) obj;
                news.getGroup().getMembers().add(grp);
            }
        }
    }
}
