/*
 * Created on 2005/01/25
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.ui.actions;

import java.util.Iterator;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkbenchSite;

import razgriz.news.model.Article;
import razgriz.news.model.ModelElement;
import razgriz.news.model.News;
import razgriz.news.visitor.RemoveReadArticleVisitor;

/**
 * 
 */
public class RemoveReadArticleAction extends Action {
    public static final String ID = RemoveReadArticleAction.class.getName();

    IWorkbenchSite site;
    Viewer viewer;
    
    public RemoveReadArticleAction(IWorkbenchSite site, Viewer viewer) {
        super();

        this.site = site;
        this.viewer = viewer;

        setId(ID);
        setText("ǂ폜");
        setToolTipText("ׂĂ̊ǋL폜܂");
        setImageDescriptor(null);
    }

    public void run() {
        IStructuredSelection sel =
            (IStructuredSelection) viewer.getSelection();

        for (Iterator ite = sel.iterator(); ite.hasNext(); ) {
            Object obj = ite.next();
            if (obj instanceof Article) {
                News news = ((Article) obj).getNews();
                news.accept(new RemoveReadArticleVisitor());
            } else {
                ModelElement elem = (ModelElement) obj;
                elem.accept(new RemoveReadArticleVisitor());
            }
        }
    }
}
