/*
 * Created on 2005/03/08
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.ui.browser;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;

/**
 * 
 */
public class NewsEditor extends MultiPageEditorPart {
    public static final String ID = NewsEditor.class.getName();

    private int overviewPageIndex;
    private int browserPageIndex;

    private void createOverviewPage() {
        Composite composite = new Composite(getContainer(), SWT.NONE);
        GridLayout layout = new GridLayout();
        composite.setLayout(layout);
        layout.numColumns = 1;

        NewsEditorInput input = (NewsEditorInput) getEditorInput();

        Label titlelabel = new Label(composite, SWT.NONE);
        titlelabel.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        titlelabel.setText("^Cg: " + input.getArticle().getTitle());

        Label linklabel = new Label(composite, SWT.NONE);
        linklabel.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        linklabel.setText("N: " + input.getArticle().getLink());

        Label desclabel = new Label(composite, SWT.NONE);
        desclabel.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        desclabel.setText(": " + input.getArticle().getDescription());

        overviewPageIndex = addPage(composite);
        setPageText(overviewPageIndex, "Tv");
    }

    private void createBrowserPage() {
        NewsEditorInput input = (NewsEditorInput) getEditorInput();

        try {
            NewsBrowser browser = new NewsBrowser();
            browserPageIndex = addPage(
                browser,
                new NewsBrowserInput(input.getArticle().getLink())
             );
            
            browser.getBrowser().addTitleListener(
                new TitleListener(){
                    public void changed(TitleEvent event) {
                        setPartName(event.title);
                    }
                }
            );

            browser.getBrowser().addOpenWindowListener(
                new OpenWindowListener() {
                    public void open(WindowEvent event) {
                        try {
                            NewsBrowser browser =
                                (NewsBrowser) getSite().getPage().openEditor(
                                    new NewsBrowserInput(""),
                                    NewsBrowser.ID
                                );
                            event.browser = browser.getBrowser();
                        } catch (PartInitException e) {
                            throw new IllegalArgumentException(e.getMessage()); // todo:
                        }
                    }
                }
            );
            setPageText(browserPageIndex, "Rec");
        } catch (PartInitException e) {
            throw new IllegalStateException(e.getMessage()); // todo:
        }
    }

    protected void createPages() {
        createOverviewPage();
        createBrowserPage();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void activateOverviewPage() {
        setActivePage(overviewPageIndex);
    }
    public void activateBrowserPage() {
        setActivePage(browserPageIndex);
    }
}