#include  "act_ozip_gtk_user_interface.h"
#include  "autogen_act_ozip.h"

Act_Ozip_Gtk_User_Interface::Act_Ozip_Gtk_User_Interface
				( const Field_Recog_Interface &  f ,
				  bool  handle_gtk_event ,
				  bool  true_view ,
				  int  valid_player_threshold ,
				  double  base_player_size ,
				  double  player_size_rate ,
				  double  burn_out ,
				  const std::pair<int, int> &  window_size )
	: Soccer_Action( f ) ,
	  presentation() , architecture() , controller() , q()
{
	architecture = new Gtk_Interface_Architecture( f );
	controller   = new Gtk_Interface_Controller( architecture );
	presentation = new Interactive_Window( controller ,
					       handle_gtk_event ,
					       true_view ,
					       valid_player_threshold ,
					       base_player_size ,
					       player_size_rate ,
					       burn_out ,
					       window_size );
	controller -> set_presentation( presentation );

	q.push( new Act_Ozip( f , controller ) );

	presentation -> show();
}

Act_Ozip_Gtk_User_Interface::~Act_Ozip_Gtk_User_Interface()
{
}

ref_count_ptr<Soccer_Action>  Act_Ozip_Gtk_User_Interface::copy() const
{
	return( static_cast<Soccer_Action *>(0) );
}

bool  Act_Ozip_Gtk_User_Interface::finished() const
{
	return( false );
}

Soccer_Composite_Command  Act_Ozip_Gtk_User_Interface::action()
{
	controller -> step_start();

	Soccer_Composite_Command	command;

	if ( q )
	{
		command = q.pop();
	}
	else
	{
		command = Soccer_Command::No_Command();
	}

	controller -> step_end();

	return( command );
}
