#include  "gtk_agent_environment.h"

Gtk_Agent_Environment::Gtk_Agent_Environment
				( const Gtk_Agent_Option_Analyser &  opt )
	: Soccer_Agent_Environment( opt )
{
}

Gtk_Agent_Environment::~Gtk_Agent_Environment()
{
}

void   Gtk_Agent_Environment::run()
{
	for ( size_t  i = 0  ;  i < (this -> fd_list().size())  ;  i ++ )
	{
		gtk_input_add_full
			( static_cast<gint>( this -> fd_list()[i] ) ,
			  static_cast<GdkInputCondition>
			  ( GDK_INPUT_READ | GDK_INPUT_EXCEPTION ) ,
			  &Gtk_Agent_Environment::update_environment ,
			  static_cast<GtkCallbackMarshal>(0) ,
			  this ,
			  static_cast<GtkDestroyNotify>(0) );
	}

	Gtk::Main::run();


	if ( this -> valid() )
	{
		this -> send_composite_command( Soccer_Command::Bye() );
	}
}


void   Gtk_Agent_Environment::update_environment
				( void *  env_void ,
				  gint ,
				  GdkInputCondition )
{
	Gtk_Agent_Environment *  env
		= static_cast<Gtk_Agent_Environment *>( env_void );

	if ( env -> valid() )
	{
		env -> update( false );

		if ( env -> next_step_ready() )
		{
			env -> next_step();

			try
			{
				if ( env -> action
				  && ! env -> action -> finished() )
				{
					env -> send_composite_command
					  ( env -> action -> get_command() );
				}
			}
			catch
			   ( const Command_Queue::Empty_Queue_Pop_Exception & )
			{
				cerr << "empty queue popped!!" << endl;

				abort();
			}
		}
	}
}
