#include  "gtk_agent_option_analyser.h"
#include  <utility>

int	Gtk_Agent_Option_Analyser::DEFAULT_VALID_PLAYER_THRESHOLD = -60;
double	Gtk_Agent_Option_Analyser::DEFAULT_BASE_PLAYER_SIZE = 1.3;
double	Gtk_Agent_Option_Analyser::DEFAULT_PLAYER_SIZE_RATE = 0.04;


//
// local class for --default-window-size option
//
class  Window_Size_Option_Descripter
	: public Option_Analyser::Option_Descripter
{
protected:
	mutable	std::pair<int, int> *	size;

public:
	Window_Size_Option_Descripter( std::pair<int, int> *  s )
		: size( s ) {}

	virtual	~Window_Size_Option_Descripter() {}

	virtual	int	execute( const std::vector<std::string> &  arg ) const
	{
		if ( arg.size() < 1 )
		{
			return( -1 );
		}

		int	window_width  = 0;
		int	window_height = 0;
		int	n = 0;

		if ( std::sscanf( arg[0].c_str() ,
				  "%dx%d%n" ,
				  &window_width , &window_height , &n ) == 2
		     && arg[0][n] == '\0' )
		{
			*(this -> size) = std::pair<int, int>( window_width ,
							       window_height );

			return( 1 );
		}
		else
		{
			std::cerr << "Bad window size \"" << arg[0] << "\"."
				  << std::endl;

			std::cerr << std::endl;

			return( -1 );
		}
	}
};


Gtk_Agent_Option_Analyser::Gtk_Agent_Option_Analyser
		 ( const std::string &  default_team_name ,
		   bool  default_goalie_flag ,
		   bool  default_coach_flag ,
		   const std::string &  default_host_name ,
		   ip_port_number_t  default_port_number ,
		   bool  default_with_debug_server ,
		   const std::string &  default_debug_host_name ,
		   ip_port_number_t  default_debug_port_number ,
		   int  default_server_major_version ,
		   int  default_server_minor_version )
	 : Soccer_Option_Analyser( default_team_name ,
				   default_goalie_flag ,
				   default_coach_flag ,
				   default_host_name ,
				   default_port_number ,
				   default_with_debug_server ,
				   default_debug_host_name ,
				   default_debug_port_number ,
				   default_server_major_version ,
				   default_server_minor_version ) ,
	   valid_pl_threshold( DEFAULT_VALID_PLAYER_THRESHOLD ) ,
	   base_pl_size( DEFAULT_BASE_PLAYER_SIZE ) ,
	   pl_size_rate( DEFAULT_PLAYER_SIZE_RATE ) ,
	   fixed_pl_size( false ) ,
	   burn_out_flag( true ) ,
	   window_size( 0 , 0 )
{
	this -> add_long_option_integer( "--valid-player-threshold" ,
					 &valid_pl_threshold );
	this -> add_long_option_float  ( "--base-player-size" ,
					 &base_pl_size );
	this -> add_long_option_float  ( "--player-size-rate" ,
					 &pl_size_rate );
	this -> add_long_option_flag_on( "--fixed-player-size" ,
					 &fixed_pl_size );
	this -> add_long_option_flag_off( "--no-burn-out" ,
					  &burn_out_flag );
	this -> add_long_option
		( "--default-window-size" ,
		  new Window_Size_Option_Descripter( &window_size ) );
}

Gtk_Agent_Option_Analyser::~Gtk_Agent_Option_Analyser()
{
}

void   Gtk_Agent_Option_Analyser::usage( std::ostream &  ostr ) const
{
	this -> Soccer_Option_Analyser::usage( ostr );

	ostr << "      --valid-player-threshold STEP (default "
	     << DEFAULT_VALID_PLAYER_THRESHOLD << " step)" << std::endl;
	ostr << "      --base-player-size SIZE (default "
	     << DEFAULT_BASE_PLAYER_SIZE << " meter)" << std::endl;
	ostr << "      --player-size-rate RATE (default "
	     << DEFAULT_PLAYER_SIZE_RATE << " meter/step)" << std::endl;
	ostr << "      --fixed-player-size" << std::endl;
	ostr << "      --no-burn-out" << std::endl;
	ostr << "      --default-window-size WIDTHxHEIGHT" << std::endl;
	ostr << " and gtk options (--display etc.)" << std::endl;
}

int    Gtk_Agent_Option_Analyser::valid_player_threshold() const
{
	return( valid_pl_threshold );
}

double  Gtk_Agent_Option_Analyser::base_player_size() const
{
	return( this -> base_pl_size );
}

double  Gtk_Agent_Option_Analyser::player_size_rate() const
{
	if ( this -> fixed_pl_size )
	{
		return( 0.0 );
	}
	else
	{
		return( this -> pl_size_rate );
	}
}

bool   Gtk_Agent_Option_Analyser::burn_out() const
{
	return( this -> burn_out_flag );
}

std::pair<int, int>  Gtk_Agent_Option_Analyser::default_window_size() const
{
	return( this -> window_size );
}
