#ifndef	   GTK_AGENT_OPTION_ANALYSER_H_INCLUDED
#define	   GTK_AGENT_OPTION_ANALYSER_H_INCLUDED

// Author:		H. Shimora
// Created:		Mar 20 2001
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Mar 20 2001    base version.
//
//

#include  "soccer_option_analyser.h"
#include  <utility>

class  Gtk_Agent_Option_Analyser : public Soccer_Option_Analyser
{
public:
	static	int	DEFAULT_VALID_PLAYER_THRESHOLD;
	static	double	DEFAULT_BASE_PLAYER_SIZE;
	static	bool	DEFAULT_FIXED_PLAYER_SIZE;
	static	double	DEFAULT_PLAYER_SIZE_RATE;

private:
	int			valid_pl_threshold;
	double			base_pl_size;
	double			pl_size_rate;
	bool			fixed_pl_size;
	bool			burn_out_flag;
	std::pair<int, int>	window_size;

public:
	 Gtk_Agent_Option_Analyser
		 ( const std::string &  default_team_name ,
		   bool  default_goalie_flag = false ,
		   bool  default_coach_flag = false ,
		   const std::string &  default_host_name = "localhost" ,
		   ip_port_number_t  default_port_number
				     = SServer_Param::DEFAULT_PORT ,
		   bool  default_with_debug_server = false ,
		   const std::string &  default_debug_host_name
					= DEBUG_HOST_SERVER_HOST ,
		   ip_port_number_t  default_debug_port_number
				     = DEBUG_PORT_RELATIVE ,
		   int  default_server_major_version = 7 ,
		   int  default_server_minor_version = 8 );

	virtual	~Gtk_Agent_Option_Analyser();

	virtual	void	usage( std::ostream &  ostr = std::cerr ) const;

	virtual	int	valid_player_threshold() const;
	virtual	double	base_player_size() const;
	virtual	double	player_size_rate() const;
	virtual	bool	burn_out() const;

	virtual	std::pair<int, int>	default_window_size() const;
};


#endif	/* GTK_AGENT_OPTION_ANALYSER_H_INCLUDED */
