#include  "gtk_interface_architecture.h"

Gtk_Interface_Architecture::Gtk_Interface_Architecture
		( const Field_Recog_Interface &  f )
	: f( f ) ,
	  mode_line_model( f ) ,
	  stamina_model( f ) ,
	  kick_flag( false ) , hard_kick_flag( true ) ,
	  kick_target_point( D2_Vector::origin() ) ,
	  get_ball_flag( false ) ,
	  move_flag( false ) , move_target_point( D2_Vector::origin() ) ,
	  neck_flag( false ) , neck_target_point( D2_Vector::origin() )
{
}

Gtk_Interface_Architecture::~Gtk_Interface_Architecture()
{
}


//
// Player_Mode_Line_Model
//
Player_Mode_Line_Model
		::Player_Mode_Line_Model( const Field_Recog_Interface &  f )
	: f( f )
{
}

Player_Mode_Line_Model::~Player_Mode_Line_Model()
{
}

bool   Player_Mode_Line_Model::valid() const
{
	return( true );
}

std::string  Player_Mode_Line_Model::left_teamname() const
{
	return( "left" );
}

std::string  Player_Mode_Line_Model::right_teamname() const
{
	return( "right" );
}

gint   Player_Mode_Line_Model::left_score() const
{
	switch( f.our_team().side_lr() )
	{
	case S_Side_LR::Left_Side:
		return( f.our_team().score() );
		break;

	case S_Side_LR::Right_Side:
		return( f.opponent_team().score() );
		break;

	default:
	case S_Side_LR::Unknown:
		return( 0 );
		break;
	}
}

gint   Player_Mode_Line_Model::right_score() const
{
	switch( f.our_team().side_lr() )
	{
	case S_Side_LR::Left_Side:
		return( f.opponent_team().score() );
		break;

	case S_Side_LR::Right_Side:
		return( f.our_team().score() );
		break;

	default:
	case S_Side_LR::Unknown:
		return( 0 );
		break;
	}
}

std::string  Player_Mode_Line_Model::play_mode() const
{
	return( f.play_mode().mode() );
}

gboolean  Player_Mode_Line_Model::inverse_x() const
{
	return( false );
}

glong  Player_Mode_Line_Model::step() const
{
	return( f.current_time().main_step() );
}


//
// Stamina_Model
//
Stamina_Model::Stamina_Model( const Field_Recog_Interface &  f )
	: f( f )
{
}

Stamina_Model::~Stamina_Model()
{
}

double  Stamina_Model::stamina() const
{
	return( f.self().stamina() );
}

double  Stamina_Model::stamina_max() const
{
	return( f.sserver_param().STAMINA_MAX() );
}
