#ifndef	   GTK_INTERFACE_ARCHITECTURE_H_INCLUDED
#define	   GTK_INTERFACE_ARCHITECTURE_H_INCLUDED

// Author:		H. Shimora
// Created:		Mar 16 2001
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Mar 16 2001    base version.
//
//

#include  "game_info_mode_line.h"
#include  "stamina_gauge.h"
#include  "field_recog_interface.h"
#include  "d2_vector.h"

class  Player_Mode_Line_Model : public Game_Info_Mode_Line::Model
{
protected:
	const Field_Recog_Interface &	f;

public:
		 Player_Mode_Line_Model( const Field_Recog_Interface & );
	virtual	~Player_Mode_Line_Model();
	virtual	bool		valid() const;
	virtual	std::string	left_teamname() const;
	virtual	std::string	right_teamname() const;
	virtual	gint		left_score() const;
	virtual	gint		right_score() const;
	virtual	std::string	play_mode() const;
	virtual	gboolean	inverse_x() const;
	virtual	glong		step() const;
};

class  Stamina_Model : public Stamina_Gauge::Model
{
protected:
	const Field_Recog_Interface &	f;

public:
		 Stamina_Model( const Field_Recog_Interface & );
	virtual	~Stamina_Model();
	virtual	double	stamina() const;
	virtual	double	stamina_max() const;
};


struct  Gtk_Interface_Architecture
{
public:
	const Field_Recog_Interface &	f;

	Player_Mode_Line_Model		mode_line_model;
	Stamina_Model			stamina_model;

public:
	bool		kick_flag;
	bool		hard_kick_flag;
	D2_Vector	kick_target_point;

	bool		get_ball_flag;

	bool		move_flag;
	D2_Vector	move_target_point;

	bool		neck_flag;
	D2_Vector	neck_target_point;

public:
	 Gtk_Interface_Architecture( const Field_Recog_Interface &  f );
	~Gtk_Interface_Architecture();
};


#endif	/* GTK_INTERFACE_ARCHITECTURE_H_INCLUDED */
