#include  "gtk_interface_controller.h"
#include  "interactive_window.h"

Gtk_Interface_Controller::Gtk_Interface_Controller
		( const ref_count_ptr<Gtk_Interface_Architecture> &  a )
	: architecture( a )  ,
	  presentation( static_cast<Interactive_Window *>(0) ) ,
	  move_clear_flag( false ) , kick_clear_flag( false )
{
}

Gtk_Interface_Controller::~Gtk_Interface_Controller()
{
}

void   Gtk_Interface_Controller::set_presentation
			( const ref_count_ptr<Interactive_Window> &  p )
{
	this -> presentation = p;
}

void   Gtk_Interface_Controller::step_start()
{
	presentation -> display();
}

void   Gtk_Interface_Controller::step_end()
{
	if ( this -> move_clear_flag )
	{
		architecture -> move_flag = false;
		this -> move_clear_flag = false;
	}

	if ( this -> kick_clear_flag )
	{
		architecture -> kick_flag = false;
		this -> kick_clear_flag = false;
	}
}


ref_count_ptr<const Gtk_Interface_Architecture>
			Gtk_Interface_Controller::get_architecture() const
{
	return( this -> architecture );
}

const Field_Recog_Interface &  Gtk_Interface_Controller::f() const
{
	return( architecture -> f );
}

const Game_Info_Mode_Line::Model &  Gtk_Interface_Controller::mode_line_model()
	const
{
	return( architecture -> mode_line_model );
}

const Stamina_Gauge::Model &  Gtk_Interface_Controller::stamina_model()
	const
{
	return( architecture -> stamina_model );
}


void   Gtk_Interface_Controller::set_kick_target( const D2_Vector &  p )
{
	this -> kick_clear_flag = false;

	architecture -> kick_flag = true;
	architecture -> kick_target_point = p;
}

void   Gtk_Interface_Controller::set_kick_type( bool  hard_kick )
{
	architecture -> hard_kick_flag = hard_kick;
}

void   Gtk_Interface_Controller::clear_kick_target()
{
	this -> kick_clear_flag = true;
}


void   Gtk_Interface_Controller::set_get_ball( bool  flag )
{
	architecture -> get_ball_flag = flag;
}


void   Gtk_Interface_Controller::set_move_target( const D2_Vector &  p )
{
	this -> move_clear_flag = false;

	architecture -> move_flag = true;
	architecture -> move_target_point = p;
}

void   Gtk_Interface_Controller::clear_move_target()
{
	this -> move_clear_flag = true;
}

void   Gtk_Interface_Controller::set_force_neck( const D2_Vector &  p )
{
	architecture -> neck_flag = true;
	architecture -> neck_target_point = p;
}

void   Gtk_Interface_Controller::clear_force_neck()
{
	architecture -> neck_flag = false;
}
