#ifndef	   GTK_INTERFACE_CONTROLLER_H_INCLUDED
#define	   GTK_INTERFACE_CONTROLLER_H_INCLUDED

// Author:		H. Shimora
// Created:		Mar 16 2001
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Mar 16 2001    base version.
//
//

#include  "field_recog_interface.h"
#include  "game_info_mode_line.h"
#include  "stamina_gauge.h"
#include  "gtk_interface_architecture.h"

class  Interactive_Window;

class  Gtk_Interface_Controller
{
protected:
	ref_count_ptr<Gtk_Interface_Architecture>	architecture;
	ref_count_ptr<Interactive_Window>		presentation;

protected:
	bool	move_clear_flag;
	bool	kick_clear_flag;

public:
	virtual	void	set_presentation
			 ( const ref_count_ptr<Interactive_Window> & );

	virtual	void	step_start();
	virtual	void	step_end();

public:
		 Gtk_Interface_Controller
			( const ref_count_ptr<Gtk_Interface_Architecture> & );

	virtual	~Gtk_Interface_Controller();

	virtual ref_count_ptr<const Gtk_Interface_Architecture>
						get_architecture() const;

	virtual	const Field_Recog_Interface &	f() const;

	virtual	const Game_Info_Mode_Line::Model &	mode_line_model()
									 const;
	virtual	const Stamina_Gauge::Model &		stamina_model() const;

	virtual	void	set_kick_target( const D2_Vector & );
	virtual	void	set_kick_type( bool  hard_kick );
	virtual	void	clear_kick_target();

	virtual	void	set_get_ball( bool );

	virtual	void	set_move_target( const D2_Vector & );
	virtual	void	clear_move_target();

	virtual	void	set_force_neck( const D2_Vector & );
	virtual	void	clear_force_neck();
};


#endif	/* GTK_INTERFACE_CONTROLLER_H_INCLUDED */
