#include  "interactive_window.h"

Interactive_Window::Interactive_Window
			( const ref_count_ptr<Gtk_Interface_Controller> &  c ,
			  bool  handle_gtk_event ,
			  bool  true_view ,
			  int  valid_player_threshold ,
			  double  base_player_size ,
			  double  player_size_rate ,
			  bool  burn_out ,
			  const std::pair<int, int> &  window_size )
	: Gtk::Window() ,
	  controller( c ) ,
	  vbox() ,
	  mode_line( c -> mode_line_model() ) ,
	  field_view( c ,
		      handle_gtk_event ,
		      true_view ,
		      valid_player_threshold ,
		      base_player_size ,
		      player_size_rate ,
		      burn_out ) ,
	  stamina_gauge( c -> stamina_model() ) ,
	  quit_button( "Quit" )
{
	vbox.set_spacing( 3 );

	vbox.pack_start( mode_line , false );
	vbox.pack_start( field_view , true );
	vbox.pack_start( stamina_gauge , false );
	vbox.pack_start( quit_button , false );

	vbox.show_all();

	this -> add( vbox );

	this -> set_title( "OZ Interactive Player" );
	this -> set_border_width( 4 );
	this -> set_policy( /* allow_shrink = */ true ,
			    /* allow_grow   = */ true ,
			    /* auto_shrink  = */ true );
	if ( window_size.first > 0  &&  window_size.second > 0 )
	{
		this -> set_default_size( window_size.first ,
					  window_size.second );
	}
}

Interactive_Window::~Interactive_Window()
{
}

gint   Interactive_Window::delete_event_impl( GdkEventAny * )
{
	Gtk::Main::quit();

	return( false );
}

void   Interactive_Window::display()
{
	mode_line.display();
	field_view.display();
	stamina_gauge.display();
}


gint Interactive_Window::key_press_event_impl( GdkEventKey *  ev )
{
	return( field_view.key_pressed( ev ) );
}

gint Interactive_Window::key_release_event_impl( GdkEventKey *  ev )
{
	return( field_view.key_released( ev ) );
}
