#ifndef	   INTERACTIVE_WINDOW_H_INCLUDED
#define	   INTERACTIVE_WINDOW_H_INCLUDED

// Author:		H. Shimora
// Created:		Mar 14 2001
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Mar 14 2001    base version.
//
//

#include  <gtk--.h>
#include  "gtk_interface_controller.h"
#include  "game_info_mode_line.h"
#include  "player_field_view.h"
#include  "stamina_gauge.h"
#include  "quit_button.h"

class  Interactive_Window : public Gtk::Window
{
protected:
	ref_count_ptr<Gtk_Interface_Controller>	controller;

protected:
	Gtk::VBox			vbox;

	Game_Info_Mode_Line		mode_line;

	Player_Field_View		field_view;

	Stamina_Gauge			stamina_gauge;

	Quit_Button			quit_button;

public:
		 Interactive_Window
			( const ref_count_ptr<Gtk_Interface_Controller> & ,
			  bool  handle_gtk_event ,
			  bool  true_view ,
			  int  valid_player_threshold ,
			  double  base_player_size ,
			  double  player_size_rate ,
			  bool  burn_out ,
			  const std::pair<int, int> &  window_size );

	virtual	~Interactive_Window();

	virtual	gint	delete_event_impl( GdkEventAny * );

	virtual	void	display();


	virtual	gint	key_press_event_impl( GdkEventKey * );
	virtual	gint	key_release_event_impl( GdkEventKey * );
};


#endif	/* INTERACTIVE_WINDOW_H_INCLUDED */
