//
// Display part is based on soccermonitor provided by Itsuki Noda.
//
#include  "gtk_agent_environment.h"
#include  "act_ozip_gtk_user_interface.h"

using namespace std;

int    main( int  argc ,  char *  argv[] )
{
	Gtk::Main	gtk( &argc , &argv );


	//
	// Interpret Option
	//
	Gtk_Agent_Option_Analyser
		opt( "OZ-RP" /* default team name */ ,
		     false   /* default is field player */ );

	if ( ! opt.analyse( argc , argv ) )
	{
		opt.usage();
		return( 1 );
	}
	else if ( opt.help() )
	{
		opt.usage();
		return( 0 );
	}


	//
	// Build Agent Environment
	//
	Gtk_Agent_Environment	agent_environment( opt );

	if ( ! agent_environment.valid() )
	{
		return( 1 );
	}


	//
	// Make Action
	//
	ref_count_ptr<Soccer_Action>	action;

	action = new Act_Ozip_Gtk_User_Interface
				( agent_environment.field_recog_interface() ,
				  true ,
				  opt.true_view() ,
				  opt.valid_player_threshold() ,
				  opt.base_player_size() ,
				  opt.player_size_rate() ,
				  opt.burn_out() ,
				  opt.default_window_size() );


	//
	// Register Action
	//
	agent_environment.set_action( action );


	//
	// Main Loop
	//
	agent_environment.run();


	return( 0 );
}
