#include  "player_field_canvas.h"

Player_Field_Canvas::Player_Field_Canvas
			( Field_Canvas::Canvas_Event_Handler &  handler ,
			  const SServer_Param &  param ,
			  gdouble  view_point_x ,  gdouble  view_point_y ,
			  gdouble  mag ,  bool  inv_x ,  bool  inv_y )
	: Field_Canvas( handler , param ,
			view_point_x , view_point_y , mag , inv_x , inv_y )
{
}

Player_Field_Canvas::~Player_Field_Canvas()
{
}


void   Player_Field_Canvas::gc_font_initialize_hook()
{
	move_target_mark_gc.create( get_window() , "dark blue" );
	kick_target_mark_gc.create( get_window() , "ghost white" );
	neck_target_mark_gc.create( get_window() , "yellow" );
	kickable_circle_gc .create( get_window() , "snow" );
	player_circle_gc   .create( get_window() , "snow" );
	velocity_gc        .create( get_window() , "pink" );
}

void   Player_Field_Canvas::draw_play_mode( const std::string &  mode_string )
{
	gint	lbearing;
	gint	rbearing;
	gint	text_width;
	gint	ascent;
	gint	descent;

	popup_font.string_extents( mode_string ,
				   lbearing , rbearing ,
				   text_width ,
				   ascent , descent );

	gint	message_width = rbearing - lbearing;

	gint	message_x = width() - message_width - 5;
	gint	message_y = height() - 8;

	this -> pixmap.entity().draw_string
		( popup_font , popup_string_gc ,
		  message_x , message_y , mode_string );
}

void   Player_Field_Canvas::draw_move_target_mark( const D2_Vector &  point ,
						   S_Side_LR  self_side )
{
	const	double	x_size = 1.0;

	D2_Vector	p;

	if ( self_side == S_Side_LR::Right_Side )
	{
		p = - point;
	}
	else
	{
		p = + point;
	}

	//
	// draw 'X' mark
	//
	pixmap.draw_line_absolute( move_target_mark_gc ,
				   p.x() - x_size ,  p.y() - x_size ,
				   p.x() + x_size ,  p.y() + x_size );

	pixmap.draw_line_absolute( move_target_mark_gc ,
				   p.x() - x_size ,  p.y() + x_size ,
				   p.x() + x_size ,  p.y() - x_size );
}

void   Player_Field_Canvas::draw_neck_target_mark
			( const D2_Vector &  point ,  S_Side_LR  self_side )
{
	const	double	x_size = 0.8;

	D2_Vector	p;

	if ( self_side == S_Side_LR::Right_Side )
	{
		p = - point;
	}
	else
	{
		p = + point;
	}

	//
	// draw 'X' mark
	//
	pixmap.draw_line_absolute( neck_target_mark_gc ,
				   p.x() - x_size ,  p.y() - x_size ,
				   p.x() + x_size ,  p.y() + x_size );

	pixmap.draw_line_absolute( neck_target_mark_gc ,
				   p.x() - x_size ,  p.y() + x_size ,
				   p.x() + x_size ,  p.y() - x_size );
}

void   Player_Field_Canvas::draw_kick_target_mark( const D2_Vector &  point ,
						   S_Side_LR  self_side )
{
	const	double	x_size = 1.0;

	D2_Vector	p;

	if ( self_side == S_Side_LR::Right_Side )
	{
		p = - point;
	}
	else
	{
		p = + point;
	}

	//
	// draw 'X' mark
	//
	pixmap.draw_line_absolute( kick_target_mark_gc ,
				   p.x() - x_size ,  p.y() - x_size ,
				   p.x() + x_size ,  p.y() + x_size );

	pixmap.draw_line_absolute( kick_target_mark_gc ,
				   p.x() - x_size ,  p.y() + x_size ,
				   p.x() + x_size ,  p.y() - x_size );
}

void   Player_Field_Canvas::draw_player_kickable_circle
						( const D2_Vector &  point ,
						  gdouble  r ,
						  S_Side_LR  self_side )
{
	D2_Vector	p;

	if ( self_side == S_Side_LR::Right_Side )
	{
		p = - point;
	}
	else
	{
		p = + point;
	}

	this -> pixmap.draw_arc_absolute_another_interface
			( kickable_circle_gc ,
			  false ,
			  p.x() , p.y() ,
			  r , r ,
			  0.0 , 360.0 );
}

void   Player_Field_Canvas::draw_player_circle( const D2_Vector &  point ,
						gdouble  r ,
						S_Side_LR  self_side )
{
	D2_Vector	p;

	if ( self_side == S_Side_LR::Right_Side )
	{
		p = - point;
	}
	else
	{
		p = + point;
	}

	this -> pixmap.draw_arc_absolute_another_interface
			( player_circle_gc ,
			  false ,
			  p.x() , p.y() ,
			  r , r ,
			  0.0 , 360.0 );
}

void   Player_Field_Canvas::draw_velocity( const D2_Vector &  point ,
					   const D2_Vector &  velocity ,
					   S_Side_LR  self_side )
{
	D2_Vector	p;

	if ( self_side == S_Side_LR::Right_Side )
	{
		p = - point;
	}
	else
	{
		p = + point;
	}

	const	double	VELOCITY_RATE = 20.0;

	D2_Vector	to = point + velocity * VELOCITY_RATE;

	this -> pixmap.draw_line_absolute( velocity_gc ,
					   point.x() , point.y() ,
					   to.x() , to.y() );
}
