#ifndef	   PLAYER_FIELD_CANVAS_H_INCLUDED
#define	   PLAYER_FIELD_CANVAS_H_INCLUDED

// Author:		H. Shimora
// Created:		Mar 16 2001
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Mar 16 2001    base version.
//
//

#include  "field_canvas.h"
#include  "gdk_gc_wrapper.h"
#include  <string>

class  Player_Field_Canvas : public Field_Canvas
{
protected:
	Gdk_GC_Wrapper	move_target_mark_gc;
	Gdk_GC_Wrapper	kick_target_mark_gc;
	Gdk_GC_Wrapper	neck_target_mark_gc;
	Gdk_GC_Wrapper	kickable_circle_gc;
	Gdk_GC_Wrapper	player_circle_gc;
	Gdk_GC_Wrapper	velocity_gc;

protected:
	virtual	void	gc_font_initialize_hook();

public:
		 Player_Field_Canvas
			( Field_Canvas::Canvas_Event_Handler &  handler ,
			  const SServer_Param &  param ,
			  gdouble  view_point_x = 0.0 ,
			  gdouble  view_point_y = 0.0 ,
			  gdouble  mag = DEFAULT_MAGNIFY ,
			  bool  inv_x = false ,
			  bool  inv_y = false );

	virtual	~Player_Field_Canvas();

	virtual	void	draw_play_mode( const std::string &  mode_string );

	virtual	void	draw_move_target_mark( const D2_Vector &  point ,
					       S_Side_LR  self_side );

	virtual	void	draw_kick_target_mark( const D2_Vector &  point ,
					       S_Side_LR  self_side );

	virtual	void	draw_neck_target_mark( const D2_Vector &  point ,
					       S_Side_LR  self_side );

	virtual	void	draw_player_kickable_circle( const D2_Vector &  point ,
						     gdouble  r ,
						     S_Side_LR  self_side );

	virtual	void	draw_player_circle( const D2_Vector &  point ,
					    gdouble  r ,
					    S_Side_LR  self_side );

	virtual	void	draw_velocity( const D2_Vector &  point ,
				       const D2_Vector &  velocity ,
				       S_Side_LR  self_side );
};


#endif	/* PLAYER_FIELD_CANVAS_H_INCLUDED */
