#include  "player_field_view.h"
#include  <vector>
#include  <algorithm>

//
// Canvas Base Event Handler
//
Player_Field_View
  ::Field_Canvas_Base_Event_Handler::Field_Canvas_Base_Event_Handler
					( Player_Field_View &  field_view )
	: field_view( field_view )
{
}

Player_Field_View
  ::Field_Canvas_Base_Event_Handler::~Field_Canvas_Base_Event_Handler()
{
}

void   Player_Field_View::Field_Canvas_Base_Event_Handler::configured()
{
	this -> field_view.canvas_configured();
}


//
// Canvas Event Handler
//
Player_Field_View::Field_Canvas_Event_Handler::Field_Canvas_Event_Handler
					( Player_Field_View &  field_view )
	: Field_Canvas_Base_Event_Handler( field_view )
{
}

Player_Field_View::Field_Canvas_Event_Handler::~Field_Canvas_Event_Handler()
{
}

gint   Player_Field_View::Field_Canvas_Event_Handler::
	button_pressed( GdkEventButton *  ev ,  double  x ,  double  y )
{
	return( this -> field_view.button_pressed( ev , x , y ) );
}

gint   Player_Field_View::Field_Canvas_Event_Handler::
	button_released( GdkEventButton *  ev ,  double  x ,  double  y )
{
	return( this -> field_view.button_released( ev , x , y ) );
}

gint   Player_Field_View::Field_Canvas_Event_Handler::
				key_pressed( GdkEventKey *  ev )
{
	return( this -> field_view.key_pressed( ev ) );
}

gint   Player_Field_View::Field_Canvas_Event_Handler::
				key_released( GdkEventKey *  ev )
{
	return( this -> field_view.key_pressed( ev ) );
}


//
// Player_Field_View
//
Player_Field_View::Player_Field_View
			( const ref_count_ptr<Gtk_Interface_Controller> &  c ,
			  bool  handle_gtk_event ,
			  bool  true_view ,
			  int  valid_player_threshold ,
			  double  base_player_size ,
			  double  player_size_rate ,
			  bool  burn_out )
	: controller( c ) ,
	  canvas_event_handler
		( (handle_gtk_event ?
		     new Field_Canvas_Event_Handler( *this )
		   : new Field_Canvas_Base_Event_Handler( *this ) ) ) ,
	  canvas( *canvas_event_handler , controller -> f().sserver_param() ,
		  0.0 , 0.0 , Field_Canvas::DEFAULT_MAGNIFY ) ,
	  true_view( true_view ) ,
	  valid_player_threshold( valid_player_threshold ) ,
	  base_player_size( base_player_size ) ,
	  player_size_rate( player_size_rate ) ,
	  burn_out( burn_out )
{
	//
	// Field
	//
	canvas.show();
	this -> pack_start( canvas );


	//
	// this
	//
	this -> set_spacing( 5 );
}

Player_Field_View::~Player_Field_View()
{
}

void   Player_Field_View::canvas_configured()
{
	double	mag = std::min( static_cast<gdouble>( canvas.width()  )
				 / Field_Canvas::DEFAULT_WIDTH ,
				static_cast<gdouble>( canvas.height() )
				 / Field_Canvas::DEFAULT_HEIGHT )
		      * Field_Canvas::DEFAULT_MAGNIFY;

	canvas.view_change( 0.0 , 0.0 , mag );

	this -> display();
}


void   Player_Field_View::display()
{
	//
	// Clear Field
	//
	canvas.clear_field();


	const Field_Recog_Interface &	f = controller -> f();


	//
	// Offside Line
	//
	canvas.draw_offside_line( f.self().team().defence_line() ,
				  f.self().team().offence_line() ,
				  f.self().team().side_lr() );


	//
	// Draw Players
	//
	bool	draw_face_angle = !(this -> true_view);

	// make player set
	Player_Set	pl_set
		= f.player_set( new And_Player_Predicate
				( new All_Player_Except_Self_Predicate ,
				  new Coordinate_Accurate_Player_Predicate
				  ( this -> valid_player_threshold ) ) );

	std::vector< ref_count_ptr<const Player_Reference> >	all_players;

	for ( Player_Set::iterator  it = pl_set.begin()  ;
	      it != pl_set.end()  ;  it ++ )
	{
		all_players.push_back( new Player_Reference( *it ) );
	}

	// sort by accuracy_level
	struct player_less
	{
		static	bool	compare( const ref_count_ptr
					   <const Player_Reference> &  a ,
					 const ref_count_ptr
					   <const Player_Reference> &  b )
		{
			return(   a -> coordinate().accuracy_level()
				< b -> coordinate().accuracy_level() );
		}
	};

	stable_sort( all_players.begin() , all_players.end() ,
		     player_less::compare );

	// draw each player
	for ( std::vector< ref_count_ptr<const Player_Reference> >
		      ::iterator it = all_players.begin()  ;
	      it != all_players.end()  ;  it ++ )
	{
		canvas.draw_player( **it ,
				    f.self().team().side_lr() ,
				    Soccer_Command::No_Command() ,
				    this -> player_size
				     ( (*it)
				       -> coordinate().accuracy_level() ) ,
				    static_cast<const char *>(0) ,
				    draw_face_angle ,
				    false ,
				    static_cast<const char *>(0) ,
				    false );
	}


	//
	// Draw Self Player
	//
	if ( f.self().coordinate().have_info() )
	{
		canvas.draw_player
			( f.self() ,
			  f.self().team().side_lr() ,
			  f.previous_command() ,
			  this -> player_size
			   ( f.self().coordinate().accuracy_level() ) ,
			  static_cast<const char *>(0) ,
			  true ,
			  burn_out ,
			  static_cast<const char *>(0) ,
			  false );
	}


	// Draw Ball
	if ( f.ball().coordinate().have_info() )
	{
		canvas.draw_ball
			( f.ball() ,
			  f.self().team().side_lr() ,
			  0.8 ,
			  f.play_mode() ,
			  true ,
			  static_cast<const char *>(0) ,
			  false );
	}


#if 0
	//
	// Draw Player Circle
	//
	{
		canvas.draw_player_circle
			( f.self().coordinate() ,
			  20.0 ,
			  f.self().team().side_lr() );

		canvas.draw_player_circle
			( f.self().coordinate() ,
			  40.0 ,
			  f.self().team().side_lr() );

		canvas.draw_player_circle
			( f.self().coordinate() ,
			  60.0 ,
			  f.self().team().side_lr() );
	}
#endif


	//
	// Draw Kickable Circle
	//
	if ( (f.ball().coordinate() - f.self().coordinate()).r()
	     <= f.sserver_param().kickable_distance() - 0.05 )
	{
		canvas.draw_player_kickable_circle
			( f.self().coordinate() ,
			  f.sserver_param().kickable_distance() * 2.0 ,
			  f.self().team().side_lr() );
	}


	//
	// Draw Force Neck Target
	//
	if ( controller -> get_architecture() -> neck_flag )
	{
		canvas.draw_neck_target_mark
		  ( controller -> get_architecture() -> neck_target_point ,
		    f.self().team().side_lr() );
	}


	//
	// Draw Move Target
	//
	if ( controller -> get_architecture() -> move_flag )
	{
		canvas.draw_move_target_mark
		  ( controller -> get_architecture() -> move_target_point ,
		    f.self().team().side_lr() );
	}


	//
	// Draw Kick Target
	//
	if ( controller -> get_architecture() -> kick_flag )
	{
		canvas.draw_kick_target_mark
		  ( controller -> get_architecture() -> kick_target_point ,
		    f.self().team().side_lr() );
	}


	//
	// Draw Play Mode
	//
	if ( f.play_mode() != Play_Mode::Play_On )
	{
		if ( f.play_mode() == Play_Mode::Before_Kick_Off
		  && f.play_mode().start_reason().type
						   == Judgement_Type::Goal )
		{
			canvas.draw_message_center( "GOAL !!" );
		}
		else if ( (f.play_mode() == Play_Mode::Our_Free_Kick
			   || f.play_mode() == Play_Mode::Opponent_Free_Kick)
			  && f.play_mode().start_reason().type
						   == Judgement_Type::Offside )
		{
			canvas.draw_message_center( "Offside !!" );
		}
	}


	//
	// Update Field
	//
	canvas.update_field();
}

gdouble  Player_Field_View::player_size( long  accuracy ) const
{
	double	size = base_player_size + (- accuracy) * player_size_rate;

	return( (size >= 0) ? size : 0.0 );
}


gint   Player_Field_View::button_pressed( GdkEventButton *  ev ,
					  double  x ,  double  y )
{
	D2_Vector	p( x , y );

	if ( this -> controller -> f().self().team().side_lr()
	     == S_Side_LR::Right_Side )
	{
		p *= -1.0;
	}

	if ( ev -> button == 1 )
	{
		this -> controller -> set_move_target( p );
	}
	else if ( ev -> button == 2 )
	{
		this -> controller -> set_kick_target( p );
	}
	else if ( ev -> button == 3 )
	{
		this -> controller -> set_get_ball( true );
	}

	return( false );
}

gint   Player_Field_View::button_released( GdkEventButton *  ev ,
					   double , double )
{
	if ( ev -> button == 1 )
	{
		this -> controller -> clear_move_target();
	}
	else if ( ev -> button == 2 )
	{
		this -> controller -> clear_kick_target();
	}
	else if ( ev -> button == 3 )
	{
		this -> controller -> set_get_ball( false );
	}

	return( false );
}

gint   Player_Field_View::key_pressed( GdkEventKey *  ev )
{
	switch( ev -> keyval )
	{
	case GDK_Shift_L:
	case GDK_Shift_R:
		{
			double	pointer_x;
			double	pointer_y;

			canvas.get_pointer_coordinate( &pointer_x ,
						       &pointer_y );

			if ( this -> controller -> f().self().team().side_lr()
			     == S_Side_LR::Right_Side )
			{
				pointer_x *= -1.0;
				pointer_y *= -1.0;
			}

			this -> controller -> set_force_neck
					( D2_Vector( pointer_x , pointer_y ) );
		}
		break;

	case GDK_Control_L:
	case GDK_Control_R:
		this -> controller -> set_kick_type( false );
		break;

	default:
		break;
	}

	return( false );
}

gint   Player_Field_View::key_released( GdkEventKey *  ev )
{
	switch( ev -> keyval )
	{
	case GDK_Shift_L:
	case GDK_Shift_R:
		this -> controller -> clear_force_neck();
		break;

	case GDK_Control_L:
	case GDK_Control_R:
		this -> controller -> set_kick_type( true );
		break;

	default:
		break;
	}

	return( false );
}
