#ifndef	   PLAYER_FIELD_VIEW_H_INCLUDED
#define	   PLAYER_FIELD_VIEW_H_INCLUDED

// Author:		H. Shimora
// Created:		Mar 14 2001
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Mar 14 2001    base version.
//
//

#include  <gtk--.h>
#include  "player_field_canvas.h"
#include  "gtk_interface_controller.h"
#include  "ref_count_ptr.h"

class  Player_Field_View : public Gtk::VBox
{
protected:
	class  Field_Canvas_Base_Event_Handler
		: public Field_Canvas::Canvas_Event_Handler
	{
	protected:
		Player_Field_View &	field_view;

	public:
		Field_Canvas_Base_Event_Handler
				( Player_Field_View &  field_view );
		virtual	~Field_Canvas_Base_Event_Handler();
		virtual	void	configured();
	};

	class  Field_Canvas_Event_Handler
		: public Field_Canvas_Base_Event_Handler
	{
	public:
		Field_Canvas_Event_Handler( Player_Field_View &  field_view );
		virtual	~Field_Canvas_Event_Handler();
		virtual	gint	button_pressed( GdkEventButton *  ev ,
						double  x , double  y );
		virtual	gint	button_released( GdkEventButton *  ev ,
						 double  x ,  double  y );
		virtual gint	key_pressed( GdkEventKey *  ev );
		virtual gint	key_released( GdkEventKey *  ev );
	};

protected:
	const ref_count_ptr<Gtk_Interface_Controller> &	controller;

	ref_count_ptr<Field_Canvas_Base_Event_Handler>
					canvas_event_handler;
	Player_Field_Canvas		canvas;

	bool				true_view;
	int				valid_player_threshold;
	double				base_player_size;
	double				player_size_rate;
	bool				burn_out;

protected:
	virtual	gdouble	player_size( long  accuracy ) const;

public:
		 Player_Field_View
			( const ref_count_ptr<Gtk_Interface_Controller> & ,
			  bool  handle_gtk_event ,
			  bool  true_view ,
			  int  valid_player_threshold ,
			  double  base_player_size ,
			  double  player_size_rate ,
			  bool  burn_out );

	virtual	~Player_Field_View();

	virtual	void	canvas_configured();
	virtual	gint	button_pressed( GdkEventButton *  ev ,
					double  x ,  double  y );
	virtual	gint	button_released( GdkEventButton *  ev ,
					 double  x ,  double  y );
	virtual gint	key_pressed( GdkEventKey *  ev );
	virtual gint	key_released( GdkEventKey *  ev );

	virtual	void	display();
};


#endif	/* PLAYER_FIELD_VIEW_H_INCLUDED */
