#ifndef	   ADJUST_SLEEP_H_INCLUDED
#define	   ADJUST_SLEEP_H_INCLUDED

// Author:		H. Shimora
// Last-Modified:	Apr  7 2000
// Created:		Apr  7 2000
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Apr  7 2000	call raw usleep(), not adjusted.
//
//

extern "C"
{
#ifndef USE_NANOSLEEP

#	include  <unistd.h>
#	ifdef __osf__
		void	usleep( unsigned int  useconds );
#	endif

#else

#    if defined(HAVE_CONFIG_H)
#	include "config.h"
#	if defined(TIME_WITH_SYS_TIME) && defined(HAVE_SYS_TIME_H)
#	    if TIME_WITH_SYS_TIME
#		include  <sys/time.h>
#		include  <time.h>
#	    else
#		if HAVE_SYS_TIME_H
#		    include  <sys/time.h>
#		else
#		    include  <time.h>
#		endif
#	    endif
#	else
#	    include  <sys/time.h>
#	endif
#    else
#	include  <sys/time.h>
#    endif
#    include  <stddef.h>
#endif
}

class  Adjust_Sleep
{
protected:
	static	void	internal_usleep( unsigned int  microseconds )
	{
		#ifndef USE_NANOSLEEP
			::usleep( microseconds );
		#else
			struct timespec	t;
			t.tv_sec  = microseconds / 1000;
			t.tv_nsec = (microseconds % 1000) * 1000;

			::nanosleep( &t , NULL );
		#endif
	}

public:
	static	void	usleep( unsigned int  microseconds )
	{
		// XXX
		Adjust_Sleep::internal_usleep( microseconds );
	}

	static	void	sleep( unsigned int  seconds )
	{
		Adjust_Sleep::usleep( seconds * 1000 * 1000 );
	}
};


#endif	/* ADJUST_SLEEP_H_INCLUDED */
