#ifndef	   D2_COMPOSITE_STRAIGHT_LINE_DIVIDED_REGION_INTERFACE_H_INCLUDED
#define	   D2_COMPOSITE_STRAIGHT_LINE_DIVIDED_REGION_INTERFACE_H_INCLUDED

#include  "d2_region.h"
#include  "d2_straight_line_divided_region.h"
#include  "ref_count_ptr.h"

#include  <vector>

class  D2_Composite_Straight_Line_Divided_Region_Interface
{
protected:
	ref_count_ptr<const D2_Composite_Straight_Line_Divided_Region>	region;

public:
	 D2_Composite_Straight_Line_Divided_Region_Interface();
	~D2_Composite_Straight_Line_Divided_Region_Interface();

	bool		in_region( const D2_Vector & ) const;

	D2_Vector	barycenter()
			    const /* throw( D2_Region::Cannot_Calculate ) */;

	bool		closed() const;

	double		area()
			    const /* throw( D2_Region::Cannot_Calculate ) */;

	std::vector<D2_Vector>	point_list() const;

	D2_Region	get_region() const;


	void	add( const D2_Straight_Line &  line ,
		     bool  positive_side ,  bool  include_line = true );

	void	add( const D2_Vector &  base ,  const Angle &  dir,
		     bool  positive_side ,  bool  include_line = true );

	void	add( const D2_Vector &  from ,  const D2_Vector &  to ,
		     bool  positive_side ,  bool  include_line = true );

	void	add( double  a ,  double  b ,  double  c ,
		     bool  positive_side ,  bool  include_line = true );


	void	add( const D2_Straight_Line &  line ,
		     const D2_Vector &  point ,  bool  include_line = true );

	void	add( const D2_Vector &  base ,  const Angle &  dir ,
		     const D2_Vector &  point ,  bool  include_line = true );

	void	add( const D2_Vector &  from ,  const D2_Vector &  to ,
		     const D2_Vector &  point ,  bool  include_line = true );

	void	add( double  a ,  double  b ,  double  c ,
		     const D2_Vector & ,  bool  include_line = true );

};


#endif	/* D2_COMPOSITE_STRAIGHT_LINE_DIVIDED_REGION_INTERFACE_H_INCLUDED */
