#ifndef	   D2_VECTOR_H_INCLUDED
#define	   D2_VECTOR_H_INCLUDED

// Author:		H. Shimora
// Last-Modified:	Apr  3 2000
// Version:		0.20

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.10  Jul 29 1998	base version.
//
// version 0.11  Mar 17 1999	some "const" added.
//
// version 0.20  Apr  3 2000	theta() returns Angle class
//
//

#ifdef HAVE_CONFIG_H
# include  "config.h"
#endif

#include  "angle.h"

//
//  D2_Vector
//
//    2 dimentional mathmatical vector class.
//

class  D2_Vector
{
public:
	enum XY_or_Pole{ XY , Pole };

protected:
	mutable	bool	xy_calculated;
	mutable	double	x_value;
	mutable	double	y_value;

	mutable	bool	pole_calculated;
	mutable	double	r_value;
	mutable	double	theta_value;

	void	calculate_xy() const;
	void	calculate_pole() const;

	static	const double	EPSILON;


public:
	 D2_Vector();
	 D2_Vector( XY_or_Pole  type ,  double  x_or_r ,  double  y_or_theta );
	 D2_Vector( XY_or_Pole  type ,  double  r ,  const Angle &  theta );
	 D2_Vector( double  x ,  double  y );
	 D2_Vector( const D2_Vector &  vec );
	~D2_Vector();

	double	x() const;
	double	y() const;

	double	r() const;
	Angle	theta() const;

	D2_Vector	normalize() const;
	D2_Vector	rotate( const Angle &  d ) const;

	D2_Vector	normalize_theta() const;

	D2_Vector	operator + () const;
	D2_Vector	operator - () const;
	D2_Vector	operator + ( const D2_Vector &  vec ) const;
	D2_Vector	operator - ( const D2_Vector &  vec ) const;
	D2_Vector	operator * ( double  d ) const;
	D2_Vector	operator / ( double  d ) const;
	D2_Vector &	operator +=( const D2_Vector &  vec );
	D2_Vector &	operator -=( const D2_Vector &  vec );
	D2_Vector &	operator *=( double  d );
	D2_Vector &	operator /=( double  d );

	D2_Vector &	set( XY_or_Pole  type ,
			     double  x_or_r ,  double  y_or_theta );

	D2_Vector &	set( XY_or_Pole  type ,
			     double  r ,  const Angle &  theta );

	D2_Vector &	set( double  r ,  const Angle &  theta );

	D2_Vector &	set( double  x_val ,  double  y_val );

	D2_Vector &	set( const D2_Vector &  vec );

	D2_Vector &	set_x( double  x );
	D2_Vector &	set_y( double  y );
	D2_Vector &	set_r( double  r );
	D2_Vector &	set_theta( const Angle &  theta );

	D2_Vector &	operator = ( const D2_Vector &  vec );

	bool		operator == ( const D2_Vector &  vec ) const;
	bool		operator != ( const D2_Vector &  vec ) const;
	bool		equal( const D2_Vector &  vec ,
			       double  epsiron = 0.0 ) const;

	static	D2_Vector	origin();

	static	double	deg_to_rad( double  x );
	static	double	rad_to_deg( double  x );

	static	double	eps();
};

D2_Vector  operator * ( double  d ,  const D2_Vector &  vec );

#include  <iostream>
std::ostream &  operator << ( std::ostream &  ostr ,  const D2_Vector &  vec );

#define	D2_VECTOR_INLINE	inline
#include  "d2_vector_inline.cc"
#undef	D2_VECTOR_INLINE

#endif	/* D2_VECTOR_H_INCLUDED */
