#ifndef	   DEBUGSTREAM_H_INCLUDED
#define	   DEBUGSTREAM_H_INCLUDED

// Author:		H. Shimora
// Created:		Mar 11 2000
// Last-Modified:	Mar 11 2000
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Mar 11 2000    test version.
//
//

#ifdef HAVE_CONFIG_H
# include  "config.h"
#endif

#include  <iostream>
#include  "nullbuf.h"

namespace Debug_Stream {

class  debugstream : public std::iostream
{
protected:
	nullbuf		null_buffer;

public:
		 debugstream() : std::iostream( &null_buffer ) {}
	virtual	~debugstream() {}

	virtual	void	inhibit( bool  flag = true )
		{
			if ( flag )
			{
				this -> rdbuf( &null_buffer );
			}
			else
			{
				this -> rdbuf( std::cout.rdbuf() );
			}
		}

	virtual	int	printf( const char *  fmt , ... );
};

extern	debugstream	dbg;

} // end of namespace Debug_Stream


#endif	/* DEBUGSTREAM_H_INCLUDED */
