#ifndef	   PROF_STOPWATCH_H_INCLUDED
#define	   PROF_STOPWATCH_H_INCLUDED

#ifdef HEVE_CONFIG_H
#    include  "config.h"
#endif

#include  <sys/types.h>
#if defined(TIME_WITH_SYS_TIME) && defined(HAVE_SYS_TIME_H)
#    if TIME_WITH_SYS_TIME
#	include  <sys/time.h>
#	include  <time.h>
#    else
#	if HAVE_SYS_TIME_H
#	    include  <sys/time.h>
#	else
#	    include  <time.h>
#	endif
#    endif
#else
#    include  <sys/time.h>
#endif

#ifdef HAVE_SYS_RESOURCE_H
#    if HAVE_SYS_RESOURCE_H
#	include  <sys/resource.h>
#    endif
#else
#    include  <sys/resource.h>
#endif


#include  "time_stamp.h"

//
// Stopwatch Library for Profiling
//
class  Prof_Stopwatch
{
protected:
	Time_Stamp	ts_start;
	struct rusage	ru_start;

	Time_Stamp	ts_stop;
	struct rusage	ru_stop;

public:
	 Prof_Stopwatch();
	~Prof_Stopwatch();

	int	start();
	int	stop();

	Time_Stamp::Time_Diff	real() const;
	Time_Stamp::Time_Diff	user() const;
	Time_Stamp::Time_Diff	sys() const;
};

#if 0
#include  <ostream>
#else
#include  <iostream>
#endif
extern std::ostream &  operator << ( std::ostream &  ostrm ,
				     const Prof_Stopwatch &  s );


#endif	/* PROF_STOPWATCH_H_INCLUDED */
