#ifndef	   ANGLE_H_INCLUDED
#define	   ANGLE_H_INCLUDED

#ifdef HAVE_CONFIG_H
# include  "config.h"
#endif

#include  <cmath>
#include  "math_extention.h"

//
// Angle
//
class  Angle
{
public:
	enum Unit { Radian , Degree };

protected:
	double	ang;

public:
	static	double	deg_to_rad( double  x )
		{
			return( x * Math_Extention::PI / 180.0 );
		}

	static	double	rad_to_deg( double  x )
		{
			return( x * 180.0 / Math_Extention::PI );
		}

	static	double  normalize_angle( double  dir ,
					 bool  use_radian = true )
		{
			double	half;

			if ( use_radian )
			{
				half = Math_Extention::PI;
			}
			else
			{
				half = 180.0;
			}

			if ( dir >= half )
			{
				do
				{
					dir -= 2.0 * half;

				} while( dir >= half );
			}
			else if ( dir < (-half) )
			{
				do
				{
					dir += 2.0 * half;

				} while( dir < (-half) );
			}

			return( dir );
		}

	static	Angle	atan2( double  y ,  double  x )
		{
			return( Angle( Angle::Radian , std::atan2( y , x ) ) );
		}

public:
		Angle()
		{
			this -> ang = 0.0;
		}

		Angle( Unit  u ,  double  value )
		{
			if ( u == Radian )
			{
				this -> ang = value;
			}
			else
			{
				this -> ang = deg_to_rad( value );
			}
		}

	virtual	~Angle()
		{
		}

	virtual	double	radian() const
		{
			return( this -> ang );
		}

	virtual	double	degree() const
		{
			return( Angle::rad_to_deg( this -> ang ) );
		}

	virtual	Angle	normalize() const
		{
			return( Angle( Angle::Radian ,
				       Angle::normalize_angle(this -> ang) ) );
		}


	virtual	Angle &	operator = ( const Angle &  a )
		{
			this -> ang = a.ang;
			return( *this );
		}

	virtual	bool	operator< ( const Angle &  a ) const
					{ return( this -> ang <  a.ang ); }
	virtual	bool	operator> ( const Angle &  a ) const
					{ return( this -> ang >  a.ang ); }
	virtual	bool	operator<=( const Angle &  a ) const
					{ return( this -> ang <= a.ang ); }
	virtual	bool	operator>=( const Angle &  a ) const
					{ return( this -> ang >= a.ang ); }
	virtual	bool	operator==( const Angle &  a ) const
					{ return( this -> ang == a.ang ); }
	virtual	bool	operator!=( const Angle &  a ) const
					{ return( this -> ang != a.ang ); }

	virtual	Angle	operator+ ( const Angle &  a ) const
		{
			return( Angle( Angle::Radian , this -> ang + a.ang ) );
		}

	virtual	Angle	operator- ( const Angle &  a ) const
		{
			return( Angle( Angle::Radian , this -> ang - a.ang ) );
		}

	virtual	double	operator/ ( const Angle &  a ) const
		{
			return( this -> ang / a.ang );
		}

	virtual	Angle	operator* ( double  x ) const
		{
			return( Angle( Angle::Radian , this -> ang * x ) );
		}

	virtual	Angle	operator/ ( double  x ) const
		{
			return( Angle( Angle::Radian , this -> ang / x ) );
		}

	virtual	Angle &	operator+= ( const Angle &  a )
		{
			this -> ang += a.ang;
			return( *this );
		}

	virtual	Angle &	operator-= ( const Angle &  a )
		{
			this -> ang -= a.ang;
			return( *this );
		}

	virtual	Angle &	operator*= ( double  x )
		{
			this -> ang *= x;
			return( *this );
		}

	virtual	Angle &	operator/= ( double  x )
		{
			this -> ang /= x;
			return( *this );
		}

	virtual	Angle	abs() const
		{
			return( Angle( Angle::Radian ,
				       std::fabs( static_cast<double>
						  ( this -> ang ) ) ) );
		}

	virtual	double	sin() const
		{
			return( std::sin( static_cast<double>
					  ( this -> ang ) ) );
		}

	virtual	double	cos() const
		{
			return( std::cos( static_cast<double>
					  ( this -> ang ) ) );
		}

	virtual	double	tan() const
		{
			return( std::tan( static_cast<double>
					  ( this -> ang ) ) );
		}

	virtual	double	sinh() const
		{
			return( std::sinh( static_cast<double>
					   ( this -> ang ) ) );
		}

	virtual	double	cosh() const
		{
			return( std::cosh( static_cast<double>
					   ( this -> ang ) ) );
		}

	virtual	double	tanh() const
		{
			return( std::tanh( static_cast<double>
					   ( this -> ang ) ) );
		}

	static	Angle	origin()
		{
			return( Angle( Angle::Radian , 0.0 ) );
		}
};

inline
Angle	operator+ ( const Angle &  a )
{
	return( a );
}

inline
Angle	operator- ( const Angle &  a )
{
	return( a * (-1.0) );
}

inline
Angle	operator* ( double  x ,  const Angle &  a )
{
	return( a * x );
}


//
// Radian
//
class  Radian : public Angle
{
public:
		 Radian( double  x ) : Angle( Angle::Radian , x ) {}
		 Radian( const Angle &  a ) : Angle( a ) {}
	virtual	~Radian() {}
};

//
// Degree
//
class  Degree : public Angle
{
public:
		 Degree( double  x ) : Angle( Angle::Degree , x ) {}
		 Degree( const Angle &  a ) : Angle( a ) {}
	virtual	~Degree() {}
};


#endif	/* ANGLE_H_INCLUDED */
