#ifndef	   COMSTREAM_H_INCLUDED
#define	   COMSTREAM_H_INCLUDED

#include  <iostream>
#include  <string>
#include  <vector>
#include  <csignal>
#include  <cstdarg>

#include  "commandbuf.h"

class  comstream : public std::iostream
{
public:
	enum { BAD_PROCESSS_ID = commandbuf::BAD_PROCESSS_ID };
	enum { BAD_FD          = commandbuf::BAD_FD };

protected:
	commandbuf	buf;

public:
		 comstream( const char * const * const  argv )
			 : std::iostream( &buf ) , buf( argv ) {}

		 comstream( const char *  file ,
			    const char * const * const  argv )
			 : std::iostream( &buf ) , buf( file , argv ) {}

		 comstream( const std::vector<std::string> &  argv )
			 : std::iostream( &buf ) , buf( argv ) {}

		 comstream( const std::string &  file ,
			    const std::vector<std::string> &  argv )
			 : std::iostream( &buf ) , buf( file , argv ) {}

		 comstream( const char * argv0 , ... );

	virtual	~comstream()			{ buf.close() ; buf.kill(); }

	virtual	void	close( int  in_out )	{ buf.close( in_out ); }
	virtual	pid_t	getpid()		{ return( buf.getpid() ); }
	virtual	int	kill( int  sig = SIGTERM )
					{ return( buf.kill( sig ) ); }
	virtual	int	fd( int  in_out )	{ return( buf.fd( in_out ) ); }
};


inline
comstream::comstream( const char *  argv0 , ... )
	: std::iostream( &buf ) , buf()
{
	std::vector<std::string>	argv;
	argv.push_back( argv0 );

	va_list	ap;
	va_start( ap , argv0 );

	for(;;)
	{
		const char *	p = va_arg( ap , const char * );

		if ( ! p )
		{
			break;
		}

		argv.push_back( p );
	}

	va_end( ap );

	buf.invoke( std::string(argv[0]) , argv );
}


#endif	/* COMSTREAM_H_INCLUDED */
