#include  "d2_composite_straight_line_divided_region_interface.h"

using namespace std;

D2_Composite_Straight_Line_Divided_Region_Interface::
	D2_Composite_Straight_Line_Divided_Region_Interface()
		: region( new D2_Composite_Straight_Line_Divided_Region() )
{
}


D2_Composite_Straight_Line_Divided_Region_Interface::
	~D2_Composite_Straight_Line_Divided_Region_Interface()
{
}

bool   D2_Composite_Straight_Line_Divided_Region_Interface::
	 in_region( const D2_Vector & point ) const
{
	return( region -> in_region( point ) );
}

D2_Vector  D2_Composite_Straight_Line_Divided_Region_Interface::barycenter()
	const // throw( D2_Region::Cannot_Calculate )
{
	return( region -> barycenter() );
}

bool   D2_Composite_Straight_Line_Divided_Region_Interface::closed() const
{
	return( region -> closed_region() );
}

double  D2_Composite_Straight_Line_Divided_Region_Interface::area()
	const // throw( D2_Region::Cannot_Calculate )
{
	return( region -> area() );
}

D2_Region  D2_Composite_Straight_Line_Divided_Region_Interface::get_region()
	const
{
	return( D2_Region( this -> region ) );
}


void   D2_Composite_Straight_Line_Divided_Region_Interface::add(
		     const D2_Straight_Line &  line ,
		     bool  positive_side ,  bool include_line )
{
	ref_count_ptr<const D2_Straight_Line_Divided_Region>	reg(
	   new D2_Straight_Line_Divided_Region(
		       line , positive_side , include_line) );

	region = region -> add( reg );
}


void   D2_Composite_Straight_Line_Divided_Region_Interface::
	add( const D2_Vector &  base ,  const Angle &  dir ,
	     bool  positive_side ,  bool include_line )
{
	ref_count_ptr<const D2_Straight_Line_Divided_Region>	reg(
	   new D2_Straight_Line_Divided_Region(
	       D2_Straight_Line(base , dir) , positive_side , include_line) );

	region = region -> add( reg );
}


void   D2_Composite_Straight_Line_Divided_Region_Interface::
	add( const D2_Vector &  from ,  const D2_Vector &  to ,
	     bool  positive_side ,  bool include_line )
{
	ref_count_ptr<const D2_Straight_Line_Divided_Region>	reg(
	   new D2_Straight_Line_Divided_Region(
	       D2_Straight_Line(from , to) , positive_side , include_line) );

	region = region -> add( reg );
}


void   D2_Composite_Straight_Line_Divided_Region_Interface::
	add( double  a , double  b , double  c ,
	     bool  positive_side ,  bool include_line )
{
	ref_count_ptr<const D2_Straight_Line_Divided_Region>	reg(
	   new D2_Straight_Line_Divided_Region(
	       D2_Straight_Line(a , b , c) , positive_side , include_line) );

	region = region -> add( reg );
}


void   D2_Composite_Straight_Line_Divided_Region_Interface::add(
		     const D2_Straight_Line &  line ,
		     const D2_Vector &  point ,  bool include_line )
{
	bool	positive_side = (line( point ) > 0);

	ref_count_ptr<const D2_Straight_Line_Divided_Region>	reg(
	   new D2_Straight_Line_Divided_Region(
			line , positive_side , include_line) );

	region = region -> add( reg );
}


void   D2_Composite_Straight_Line_Divided_Region_Interface::
	add( const D2_Vector &  base ,  const Angle &  dir ,
	     const D2_Vector &  point ,  bool include_line )
{
	D2_Straight_Line	line( base , dir );

	bool	positive_side = (line( point ) > 0);

	ref_count_ptr<const D2_Straight_Line_Divided_Region>	reg(
	   new D2_Straight_Line_Divided_Region(
		line , positive_side , include_line) );

	region = region -> add( reg );
}


void   D2_Composite_Straight_Line_Divided_Region_Interface::
	add( const D2_Vector &  from ,  const D2_Vector &  to ,
	     const D2_Vector &  point ,  bool include_line )
{
	D2_Straight_Line	line( from , to );

	bool	positive_side = (line( point ) > 0);

	ref_count_ptr<const D2_Straight_Line_Divided_Region>	reg(
	   new D2_Straight_Line_Divided_Region(
			line , positive_side , include_line) );

	region = region -> add( reg );
}


void   D2_Composite_Straight_Line_Divided_Region_Interface::
	add( double  a , double  b , double  c ,
	     const D2_Vector &  point ,  bool include_line )
{
	D2_Straight_Line	line( a , b , c );

	bool	positive_side = (line( point ) > 0);

	ref_count_ptr<const D2_Straight_Line_Divided_Region>	reg(
	   new D2_Straight_Line_Divided_Region(
	       D2_Straight_Line(a , b , c) , positive_side , include_line) );

	region = region -> add( reg );
}


vector<D2_Vector>  D2_Composite_Straight_Line_Divided_Region_Interface
							  ::point_list() const
{
	return( region -> point_list() );
}
