#include  "d2_point.h"

D2_Point::D2_Point( const D2_Vector &  p )
	: point( p )
{
}

D2_Point::~D2_Point()
{
}


D2_Point::operator D2_Vector()
{
	return( point );
}

bool   D2_Point::in_region( const D2_Vector &  vec ) const
{
	return( point == vec );
}

ref_count_ptr<const D2_Region_Entity>  D2_Point::copy() const
{
	return( ref_count_ptr<const D2_Region_Entity>(
					      new D2_Point( *this ) ) );
}

D2_Vector  D2_Point::barycenter() const throw()
{
	return( point );
}

double  D2_Point::area() const throw()
{
	return( 0.0 );
}
