#include  "d2_region.h"
#include  "ref_count_ptr.h"
#include  "d2_universal_region.h"
#include  "d2_composite_region.h"
#include  "d2_point.h"


//
// D2_Region
//

D2_Region::D2_Region()
	: ent( emp_region_entity )
{
}

D2_Region::D2_Region( const ref_count_ptr<const D2_Region_Entity> &  e )
	: ent( e )
{
}

D2_Region::D2_Region( const D2_Region_Entity &  e )
	: ent( e.copy() )
{
}

D2_Region::D2_Region( const D2_Vector &  v )
	: ent( new D2_Point( v ) )
{
}

D2_Region::~D2_Region()
{
}


const ref_count_ptr<const D2_Region_Entity> &  D2_Region::entity()
{
	return( ent );
}

D2_Region  D2_Region::operator & ( const D2_Region&  region )
{
	return( (*ent) & region );
}

D2_Region  D2_Region::operator | ( const D2_Region&  region )
{
	return( (*ent) | region );
}

D2_Region  D2_Region::operator ! ()
{
	return( ! (*ent) );
}

bool   D2_Region::in_region( const D2_Vector &  point ) const
{
	return( ent -> in_region( point ) );
}

bool   D2_Region::in_region( double  x ,  double y ) const
{
	return( ent -> in_region( D2_Vector( D2_Vector::XY , x , y ) ) );
}

D2_Vector  D2_Region::barycenter()
	const // throw( Cannot_Calculate , std::exception )
{
	return( ent -> barycenter() );
}

double  D2_Region::area()
	const // throw( Cannot_Calculate , std::exception )
{
	return( ent -> area() );
}

bool   D2_Region::operator==( const D2_Region &  region ) const
{
	return( (this -> ent) == region.ent );
}

void   D2_Region::set( const D2_Region &  region )
{
	(*this) = region;
}

// private class static member
ref_count_ptr<const D2_Region_Entity>  D2_Region::emp_region_entity
						= new D2_Empty_Region();
ref_count_ptr<const D2_Region_Entity>  D2_Region::univ_region_entity
						= new D2_Universal_Region();

// class static method
D2_Region  D2_Region::empty_region()
{
	return( D2_Region::emp_region_entity );
}

// class static method
D2_Region  D2_Region::universal_region()
{
	return( D2_Region::univ_region_entity );
}




//
// D2_Region_Entity
//

D2_Region_Entity::D2_Region_Entity()
{
}

D2_Region_Entity::~D2_Region_Entity()
{
}


D2_Region  D2_Region_Entity::default_and( const D2_Region&  region ) const
{
	return( ref_count_ptr<const D2_Region_Entity>(
		 new D2_Composite_Region( D2_Composite_Region::And ,
					  this -> copy() , region ) ) );
}

D2_Region  D2_Region_Entity::default_or( const D2_Region&  region ) const
{
	return( ref_count_ptr<const D2_Region_Entity>(
		 new D2_Composite_Region( D2_Composite_Region::Or ,
					  this -> copy() , region ) ) );
}

D2_Region  D2_Region_Entity::default_not() const
{
	return( ref_count_ptr<const D2_Region_Entity>(
		 new D2_Composite_Region( D2_Composite_Region::Not ,
					  this -> copy() ) ) );
}

D2_Region  D2_Region_Entity::operator & ( const D2_Region&  region ) const
{
	return( default_and( region ) );
}

D2_Region  D2_Region_Entity::operator | ( const D2_Region&  region ) const
{
	return( default_or( region ) );
}

D2_Region  D2_Region_Entity::operator ! () const
{
	return( default_not() );
}


D2_Vector  D2_Region_Entity::barycenter()
	const // throw( D2_Region::Cannot_Calculate , std::exception )
{
	throw D2_Region::Cannot_Calculate();
}

double  D2_Region_Entity::area()
	const // throw( D2_Region::Cannot_Calculate , std::exception )
{
	throw D2_Region::Cannot_Calculate();
}
