#ifndef	   D2_STRAIGHT_LINE_H_INCLUDED
#define	   D2_STRAIGHT_LINE_H_INCLUDED

#include  "d2_region.h"
#include  "d2_point.h"
#include  "angle.h"

class  D2_Straight_Line : public D2_Region_Entity
{
protected:
	double	a;
	double	b;
	double	c;

public:
		 D2_Straight_Line( const D2_Vector &  base ,
				   double  direction );
		 D2_Straight_Line( const D2_Vector &  base ,
				   const Angle  &  direction );
		 D2_Straight_Line( const D2_Vector &  a ,
				   const D2_Vector &  b );
		 D2_Straight_Line( double  a ,  double  b ,  double  c );
	virtual	~D2_Straight_Line();

	virtual	bool		in_region( const D2_Vector &  vec ) const;
	virtual	double		area() const throw();
	virtual	ref_count_ptr<const D2_Region_Entity>	copy() const;


public:
	virtual	D2_Vector	cross_point( const D2_Straight_Line & ) const
					throw( D2_Region::No_Region_Error );

	virtual	bool		parallel( const D2_Straight_Line & ) const;

	virtual	double		operator () ( const D2_Vector & ) const;

	virtual	Angle		direction() const;
	virtual	double		distance( const D2_Vector & ) const;
	virtual	D2_Vector	sample_point() const;
	virtual	D2_Vector	project_point( const D2_Vector &  p ) const;
};


#endif	/* D2_STRAIGHT_LINE_H_INCLUDED */
