#ifndef	   D2_STRAIGHT_LINE_DIVIDED_REGION_H_INCLUDED
#define	   D2_STRAIGHT_LINE_DIVIDED_REGION_H_INCLUDED

#include  "d2_region.h"
#include  "d2_straight_line.h"

class  D2_Straight_Line_Divided_Region : public D2_Region_Entity
{
protected:
	D2_Straight_Line	staright_line;
	bool			positive_side;
	bool			include_line;

public:
	 D2_Straight_Line_Divided_Region( const D2_Straight_Line & ,
					  bool  positive_side ,
					  bool  include_line = true );
virtual	~D2_Straight_Line_Divided_Region();

virtual	bool	in_region( const D2_Vector & ) const;

virtual	ref_count_ptr<const D2_Region_Entity>	copy() const;
virtual	const D2_Straight_Line &		line() const;
virtual	D2_Vector	cross_point( const D2_Straight_Line_Divided_Region & )
									const;
virtual	bool		parallel( const D2_Straight_Line_Divided_Region & )
									const;
};


#include  <utility>
#include  <vector>

class  D2_Composite_Straight_Line_Divided_Region : public D2_Region_Entity
{
protected:
	struct  Cross_Point;
	struct  Cross_Point_and_Line
	{
		Cross_Point *	c_point;
		ref_count_ptr<const D2_Straight_Line_Divided_Region>	line;
	};

	struct  Cross_Point
	{
		D2_Vector		point;

		Cross_Point_and_Line	line[2];
	};

	bool	closed;

	std::vector< ref_count_ptr<Cross_Point> >  cross_point_set;

	std::vector< ref_count_ptr< const D2_Straight_Line_Divided_Region > >
						  line_divided_region_set;

protected:
	 D2_Composite_Straight_Line_Divided_Region(
	   const D2_Composite_Straight_Line_Divided_Region & ,
	   const ref_count_ptr< const D2_Straight_Line_Divided_Region > & );

	void	add_constructor_line_0(
	   const ref_count_ptr< const D2_Straight_Line_Divided_Region > & );

	void	add_constructor_line_1(
	   const ref_count_ptr< const D2_Straight_Line_Divided_Region > & );

	void	add_constructor_line_2(
	   const ref_count_ptr< const D2_Straight_Line_Divided_Region > & );

	void	add_constructor_line_3_or_more(
	   const ref_count_ptr< const D2_Straight_Line_Divided_Region > & );

	void	add_constructor_closed(
	   const ref_count_ptr< const D2_Straight_Line_Divided_Region > & );

	void	add_constructor_closed_cut_off(
	   const ref_count_ptr< const D2_Straight_Line_Divided_Region > & );

public:
		 D2_Composite_Straight_Line_Divided_Region();
	virtual	~D2_Composite_Straight_Line_Divided_Region();
	virtual	ref_count_ptr<const D2_Region_Entity>	copy() const;
	virtual	bool		in_region( const D2_Vector &  vec ) const;
	virtual	D2_Vector	barycenter()
				 const throw( D2_Region::Cannot_Calculate );
	virtual	double		area()
				 const throw( D2_Region::Cannot_Calculate );
	virtual	bool		closed_region() const;


public:
	ref_count_ptr< const D2_Composite_Straight_Line_Divided_Region>
	  add( const ref_count_ptr< const D2_Straight_Line_Divided_Region > & )
									const;
	std::vector<D2_Vector>	point_list() const;
};


#endif	/* D2_STRAIGHT_LINE_DIVIDED_REGION_H_INCLUDED */
