#include  "d2_universal_region.h"
#include  "ref_count_ptr.h"

//
// D2_Universal_Region
//
D2_Universal_Region::D2_Universal_Region()
{
}

D2_Universal_Region::~D2_Universal_Region()
{
}

D2_Region  D2_Universal_Region::operator & ( const D2_Region&  region ) const
{
	return( region );
}

D2_Region  D2_Universal_Region::operator | ( const D2_Region& ) const
{
	return( ref_count_ptr<const D2_Region_Entity>(
					      new D2_Universal_Region ) );
}

D2_Region  D2_Universal_Region::operator ! () const
{
	return( ref_count_ptr<const D2_Region_Entity>( new D2_Empty_Region ) );
}

bool   D2_Universal_Region::in_region( const D2_Vector & ) const
{
	return( true );
}

ref_count_ptr<const D2_Region_Entity>  D2_Universal_Region::copy() const
{
	return( ref_count_ptr<const D2_Region_Entity>(
				      new D2_Universal_Region( *this ) ) );
}




//
// D2_Empty_Region
//
D2_Empty_Region::D2_Empty_Region()
{
}

D2_Empty_Region::~D2_Empty_Region()
{
}

D2_Region  D2_Empty_Region::operator & ( const D2_Region& ) const
{
	return( ref_count_ptr<const D2_Region_Entity>( new D2_Empty_Region ) );
}

D2_Region  D2_Empty_Region::operator | ( const D2_Region&  region ) const
{
	return( region );
}

D2_Region  D2_Empty_Region::operator ! () const
{
	return( ref_count_ptr<const D2_Region_Entity>(
					      new D2_Universal_Region ) );
}

bool   D2_Empty_Region::in_region( const D2_Vector & ) const
{
	return( false );
}

ref_count_ptr<const D2_Region_Entity>  D2_Empty_Region::copy() const
{
	return( ref_count_ptr<const D2_Region_Entity>(
				      new D2_Empty_Region( *this ) ) );
}
