#ifndef	   IP_ADDRESS_H_INCLUDED
#define	   IP_ADDRESS_H_INCLUDED

#include  <string>
#include  <iostream>
#include  <cstdio>

extern "C"
{
	#include  <sys/types.h>
	#include  <sys/socket.h>
	#include  <netinet/in.h>
	#include  <netdb.h>
}

#ifdef HAVE_CONFIG_H
	#include  "config.h"
#else
	#if   defined( HAVE_INTTYPES_H )
		#include  <inttypes.h>
		typedef  uint32_t	ip_address_t;
		typedef  uint16_t	ip_port_number_t;
	#elif defined( __linux )
		typedef  unsigned long	ip_address_t;
		typedef  int		ip_port_number_t;
	#else
		typedef  unsigned long	ip_address_t;
		typedef  unsigned short	ip_port_number_t;
	#endif
#endif

//
// Internet Protocol(Version 4) Address class
//
class  IPv4_Address
{
protected:
	ip_address_t	address;

public:
	IPv4_Address( const std::string &  host )
		: address( 0x00000000 )
		{
			struct hostent *	hp;
			if ( (hp = gethostbyname( host.c_str() ))  ==  NULL )
			{
#if 0
				std::perror( "gethostbyname" );
#elif 0
				using namespace std;
				perror( "gethostbyname" );
#else
				perror( "gethostbyname" );
#endif
			}

			std::memcpy( &address ,
				     hp -> h_addr , hp -> h_length );

			// <<TRANSLATE TO HOST BYTE ORDER>>
			// translate network byte order
			//   to machne depend(NOT NETWORK) byte order
			address = htonl( address );
		}

	IPv4_Address( unsigned char  a ,  unsigned char  b ,
		      unsigned char  c ,  unsigned char  d )
		: address(   ( static_cast<ip_address_t>(a) << (8 * 3) )
			   + ( static_cast<ip_address_t>(b) << (8 * 2) )
			   + ( static_cast<ip_address_t>(c) << (8 * 1) )
			   + ( static_cast<ip_address_t>(d) << (8 * 0) ) )
		{
		}

	IPv4_Address( ip_address_t  addr )
		: address( addr )
		{
		}

	IPv4_Address( const IPv4_Address &  ip )
		: address( ip.address )
		{
		}

	operator ip_address_t() const
		{
			return( address );
		}

};


inline
std::ostream &  operator<< ( std::ostream &  ostrm ,
			     const IPv4_Address &  addr )
{
	ostrm << ((addr >> (8*3)) & 0xff) << "."
	      << ((addr >> (8*2)) & 0xff) << "."
	      << ((addr >> (8*1)) & 0xff) << "."
	      << ((addr >> (8*0)) & 0xff);

	return( ostrm );
}


#endif	/* IP_ADDRESS_H_INCLUDED */
