#ifdef     LISP_LEX_TEST

#include  <iostream>
#include  "lisp_lex.h"

static	void	indent( int  level );
static	void	print_obj( const Lisp_Lexical_Object &  obj ,  int  level );

int    main( void )
{
	Lisp_Lexical_Analyser	lex;
	Lisp_Lexical_Object	obj;

	char	input[1024];
	cerr << "> ";
	// example: "(abc def (ghi jkl) mno ((pqr (stu)))) vwx (yz)"
	cin.getline( input , sizeof(input) );
	if ( ! lex.analyze( input ) )
	{
		cerr << "Error !!" << endl;
	}

	obj = lex.result();

	print_obj( obj , 0 );

	return( 0 );
}


static
void   indent( int  level )
{
	for ( int i = 0  ;  i < level  ;  i ++ )
	{
		cout  <<  "\t";
	}
}


static
void   print_obj( const Lisp_Lexical_Object &  obj ,  int  level )
{
	indent( level );
	if ( obj.type == Lisp_Lexical_Object::Symbol )
	{
		cout << "Symbol [" << obj.symbol << "]" << endl;
	}
	else if ( obj.type == Lisp_Lexical_Object::List )
	{
		cout << "List";
		if ( ! obj.has_right_paren )
		{
			cout << " (not closed !!)";
		}
		cout << endl;

		for ( size_t  i = 0  ;  i < obj.list.size()  ;  i ++ )
		{
			print_obj( obj.list[i] , level + 1 );
		}
	}
	else if ( obj.type == Lisp_Lexical_Object::Top_Level )
	{
		cout << "Top_Level";

		if ( obj.list.empty() )
		{
			cout << " (empty)" << endl;
		}
		else
		{
			cout << endl;

			for ( size_t  i = 0  ;  i < obj.list.size()  ;  i ++ )
			{
				print_obj( obj.list[i] , level + 1 );
			}
		}
	}
	else if ( obj.type == Lisp_Lexical_Object::Bad_Type )
	{
		cout << "Bad_Type" << endl;
	}
}
#endif  // LISP_LEX_TEST




#include  "lisp_lex.h"
#include  <iostream>
//
//  Lisp_Lexical_Object
//

using namespace std;

Lisp_Lexical_Object::Lisp_Lexical_Object()
	: type( Top_Level ) ,
#if 0
	  n_quote( 0 ) ,
#endif
	  has_right_paren( false ) ,
	  list() ,
	  symbol()
{
}


Lisp_Lexical_Object::Lisp_Lexical_Object( const string &  str )
	: type( Top_Level ) ,
#if 0
	  n_quote( 0 ) ,
#endif
	  has_right_paren( false ) ,
	  list() ,
	  symbol()
{
	Lisp_Lexical_Analyser	analyser;

	(void)analyser.analyze( str );

	(*this) = analyser.result();
}

Lisp_Lexical_Object::Lisp_Lexical_Object( std::istream &  istr )
{
	Lisp_Lexical_Analyser	analyser;

	(void)analyser.analyze( istr );

	(*this) = analyser.result();
}


Lisp_Lexical_Object::Lisp_Lexical_Object( const Lisp_Lexical_Object &  llo )
	: type( llo.type ) ,
#if 0
	  n_quote( llo.n_quote ) ,
#endif
	  has_right_paren( llo.has_right_paren ) ,
	  list( llo.list ) ,
	  symbol( llo.symbol )
{
}

Lisp_Lexical_Object::~Lisp_Lexical_Object()
{
#ifdef LIB_MEMORY
	list.clear();
#endif
}


bool   Lisp_Lexical_Object::operator== ( Lisp_Lexical_Object::Object_Type  t )
	const
{
	return(	type == t );
}


bool   Lisp_Lexical_Object::operator< ( const Lisp_Lexical_Object &  x ) const
{
	return( (compare( x ) < 0) );
}


int    Lisp_Lexical_Object::compare( const Lisp_Lexical_Object &  x ) const
{
	if ( this -> type  !=  x.type )
	{
		return(   static_cast<int>(x.type)
			- static_cast<int>(this -> type) );
	}

	switch( this -> type )
	{
	case  Lisp_Lexical_Object::Symbol:
		return( symbol.compare( x.symbol ) );
		break;

	case  Lisp_Lexical_Object::List:
	case  Lisp_Lexical_Object::Top_Level:
		if ( this -> list.size() != x.list.size() )
		{
			// XXX
			return( static_cast<int>(this -> list.size())
				- static_cast<int>(x.list.size()) );
		}

		if ( this -> has_right_paren != x.has_right_paren )
		{
			return( ((this -> has_right_paren) ? -1 : 1) );
		}

		for ( size_t  i = 0  ;  i < this -> list.size()  ;  i ++ )
		{
			int	cmp = this -> list[i].compare( x.list[i] );
			if ( cmp != 0 )
			{
				return( cmp );
			}
		}

		return( 0 );
		break;

	case  Lisp_Lexical_Object::Bad_Type:
	default:
		return( 0 );
		break;
	}
}


//
//  Lisp_Lexical_Analyser
//

using namespace std;

Lisp_Lexical_Analyser::Lisp_Lexical_Analyser()
{
#if 0
	object_stack.push( &obj );
	object_stack.push( &obj );
#else
	Lisp_Lexical_Object	obj;

	dummy_obj.push_back( obj );

	object_stack.push( dummy_obj.begin() );
	object_stack.push( dummy_obj.begin() );
#endif
}


Lisp_Lexical_Analyser::Lisp_Lexical_Analyser( const string &  str )
{
#if 0
	object_stack.push( &obj );
	object_stack.push( &obj );
#else
	Lisp_Lexical_Object	obj;

	dummy_obj.push_back( obj );

	object_stack.push( dummy_obj.begin() );
	object_stack.push( dummy_obj.begin() );
#endif
	(void)analyze( str );
}


Lisp_Lexical_Analyser::Lisp_Lexical_Analyser( std::istream &  istr )
{
#if 0
	object_stack.push( &obj );
	object_stack.push( &obj );
#else
	Lisp_Lexical_Object	obj;

	dummy_obj.push_back( obj );

	object_stack.push( dummy_obj.begin() );
	object_stack.push( dummy_obj.begin() );
#endif
	(void)analyze( istr );
}



Lisp_Lexical_Analyser::~Lisp_Lexical_Analyser()
{
#ifdef LIB_MEMORY
	dummy_obj[0].list.clear();
	dummy_obj.clear();
#endif
}


Lisp_Lexical_Object  Lisp_Lexical_Analyser::result()
{
#if 0
	return( obj );
#else
	return( dummy_obj[0] );
#endif
}


bool  Lisp_Lexical_Analyser::analyze( const string &  input )
{
	bool	ret = true;

	for ( size_t i = 0  ;  i < input.length()  ;  i ++ )
	{
		ret = analyze( input[i] );
	}

	return( ret );
}

bool  Lisp_Lexical_Analyser::analyze( istream &  input )
{
	bool	ret = true;

	while( input.good() )
	{
		char	ch;
		input.get(ch);
		ret = analyze( ch );
	}

	return( ret );
}


bool  Lisp_Lexical_Analyser::analyze( char  ch )
{
#define	SP (object_stack.top())

	switch( (*SP).type )
	{
	case  Lisp_Lexical_Object::Bad_Type:
		return( false );
		break;

	case  Lisp_Lexical_Object::Top_Level:
		switch( ch )
		{
		case  ' ':
		case  '\t':
		case  '\n':
			// skip it !!
			break;

		case  '(':
			{
			Lisp_Lexical_Object	lis;
			lis.type = Lisp_Lexical_Object::List;
			(*SP).list.push_back( lis );
			object_stack.push( (*SP).list.end() - 1 );
			}
			break;

		case  ')':
			(*SP).type = Lisp_Lexical_Object::Bad_Type;
			return( false );
			break;

		default:
			{
			Lisp_Lexical_Object	lis;
			lis.type = Lisp_Lexical_Object::Symbol;
			(*SP).list.push_back( lis );
			object_stack.push( (*SP).list.end() - 1 );
			(*SP).symbol += ch;
			}
			break;
		}
		break;

	case  Lisp_Lexical_Object::List:
		switch( ch )
		{
		case  ' ':
		case  '\t':
		case  '\n':
			// skip it !!
			break;

		case  '(':
			{
			Lisp_Lexical_Object	lis;
			lis.type = Lisp_Lexical_Object::List;
			(*SP).list.push_back( lis );
			object_stack.push( (*SP).list.end() - 1 );
			}
			break;

		case  ')':
			{
			(*SP).has_right_paren = true;
			object_stack.pop();
			}
			break;

		default:
			{
			Lisp_Lexical_Object	lis;
			lis.type = Lisp_Lexical_Object::Symbol;
			(*SP).list.push_back( lis );
			object_stack.push( (*SP).list.end() - 1 );
			(*SP).symbol += ch;
			}
			break;
		}
		break;

	case  Lisp_Lexical_Object::Symbol:
		switch( ch )
		{
		case  ' ':
		case  '\t':
		case  '\n':
			object_stack.pop();
			break;

		case  '(':
			{
			object_stack.pop();
			Lisp_Lexical_Object	lis;
			lis.type = Lisp_Lexical_Object::List;
			(*SP).list.push_back( lis );
			object_stack.push( (*SP).list.end() - 1 );
			}
			break;

		case  ')':
			object_stack.pop();
			(*SP).has_right_paren = true;
			object_stack.pop();
			break;

		default:
			(*SP).symbol += ch;
			break;
		}
		break;
	}

	return( true );
#undef	SP
}
