#ifndef	   LISP_LEX_H_INCLUDED
#define	   LISP_LEX_H_INCLUDED

/// lisp_lex.h --- lexical analyze system for lisp code.

// Copyright (C) 1998 H. Shimora

// Author:		H. Shimora
// Created:		Sep 18 1998
// Last-Modified:	Sep 30 1998
// Version:		0.11

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.10  Sep 19 1998	list & symbol analysis only.
//
// version 0.11  Sep 30 1998	Lisp_Lexical_Object::operator==
//				( Lisp_Lexical_Object::Object_Type ) added.
//
//				Lisp_Lexical_Object::
//				Lisp_Lexical_Object( string ) added.
//
//				Lisp_Lexical_Analyser::
//				Lisp_Lexical_Analyser( string ) added.
//
//				bug fix. (for  too much ')' in top level)
//
//

// TODO:
//  * quote(') support.
//  * replace char to template parameter.
//  * error handling.


#ifdef HAVE_CONFIG_H
# include  "config.h"
#endif


//
//  Lisp_Lexical_Object
//
#include  <vector>
#include  <string>
#include  <iostream>

struct  Lisp_Lexical_Object
{
	typedef  enum{ List , Symbol , Top_Level , Bad_Type }  Object_Type;

	Object_Type			type;
#if 0
	int				n_quote;  // unused in this version.
#endif

	bool					has_right_paren;
	std::vector<Lisp_Lexical_Object>	list;

	std::string				symbol;

protected:
	int	compare( const Lisp_Lexical_Object & ) const;

public:
	 Lisp_Lexical_Object();
	 Lisp_Lexical_Object( const Lisp_Lexical_Object & );
	 Lisp_Lexical_Object( const std::string & );
	 Lisp_Lexical_Object( std::istream & );

	~Lisp_Lexical_Object();

	bool	operator== ( Lisp_Lexical_Object::Object_Type ) const;

	bool	operator<  ( const Lisp_Lexical_Object & ) const;
};


//
//  Lisp_Lexical_Analyser
//
#include  <vector>
#include  <stack>
#include  <string>

class  Lisp_Lexical_Analyser
{
protected:
#if 0
	std::stack< Lisp_Lexical_Object * >	object_stack;
#else
	std::stack< std::vector<Lisp_Lexical_Object>::iterator >
							object_stack;
#endif

#if 0
	Lisp_Lexical_Object			obj;
#else
	std::vector<Lisp_Lexical_Object>	dummy_obj;
#endif

public:
	 Lisp_Lexical_Analyser();
	 Lisp_Lexical_Analyser( const std::string & );
	 Lisp_Lexical_Analyser( std::istream & );
	~Lisp_Lexical_Analyser();

	 Lisp_Lexical_Analyser( const Lisp_Lexical_Analyser & );// not allowed.
	 Lisp_Lexical_Analyser & operator =
			( const Lisp_Lexical_Analyser & );// not allowed.

	bool			analyze( const std::string &  input );
	bool			analyze( std::istream &  input );
	bool			analyze( char  ch );

	Lisp_Lexical_Object	result();
};


#endif	/* LISP_LEX_H_INCLUDED */
