#include  "option_analyser.h"
#include  <iostream>
#include  <vector>
#include  <string>

//
// Option_Analyser
//
Option_Analyser::Option_Analyser()
	: valid( true )
{
}

Option_Analyser::~Option_Analyser()
{
}

bool   Option_Analyser::analyse( int  argc ,  const char *const *const  argv )
{
	if ( argc == 0 )
	{
		this -> valid = false;

		return( false );
	}

	argv_0 = argv[0];

	for ( int  indx = 1  ;  indx < argc  ;  indx ++ )
	{
		std::string	arg( argv[indx] );

		if ( long_option_map.find( arg ) != long_option_map.end() )
		{
			std::vector<std::string>	rest_args;

			for ( int  i = indx + 1  ;  i < argc  ;  i ++ )
			{
				rest_args.push_back( argv[i] );
			}

			int	used_args;

			if ( (used_args
			      = (*long_option_map.find( arg )).second
				  -> execute( rest_args )) < 0 )
			{
				this -> valid = false;
				return( false );
			}

			indx += used_args;
		}
		else if ( arg.size() >= 1 && arg[0] == '-' )
		{
			if ( arg.size() == 1 )
			{
				std::cerr << "Unknown option \""
					  << arg << "\"" << std::endl;

				this -> valid = false;
				return( false );
			}

			for ( size_t  s = 1  ;  s < arg.size()  ;  s ++ )
			{
				std::vector<std::string>	rest_args;

				for ( int  i = indx + 1  ;  i < argc  ;  i ++ )
				{
					rest_args.push_back( argv[i] );
				}

				if ( short_option_map.find( arg[s] )
					!= short_option_map.end() )
				{
					int	used_args;

					if ( (used_args
					      = (*short_option_map
						  .find( arg[s] ))
						.second
						 -> execute( rest_args )) < 0 )
					{
						this -> valid = false;
						return( false );
					}

					indx += used_args;
				}
				else
				{
					std::cerr << "Unknown option \""
						  << arg[s] << "\""
						  << std::endl;

					this -> valid = false;
					return( false );
				}
			}
		}
		else
		{
			rest_options.push_back( arg );
		}
	}


	if ( ! this -> check() )
	{
		this -> valid = false;

		return( false );
	}

	return( true );
}

const std::vector<std::string> &  Option_Analyser::rest() const
{
	return( rest_options );
}

std::string  Option_Analyser::program_name() const
{
	return( argv_0 );
}

void   Option_Analyser::usage( std::ostream & ) const
{
}

bool   Option_Analyser::check() const
{
	return( true );
}

Option_Analyser::operator  bool() const
{
	return( valid );
}


//
// Add Option
//
void   Option_Analyser::add_short_option(
		 int  short_option ,
		 const ref_count_ptr<const Option_Descripter> & opt )
{
	if ( short_option == EOF )
	{
		return;
	}

	short_option_map[short_option] = opt;
}

void   Option_Analyser::add_long_option(
			const std::string &  long_option ,
			const ref_count_ptr<const Option_Descripter> & opt )
{
	if ( long_option == "" )
	{
		return;
	}

	long_option_map[long_option] = opt;
}


void   Option_Analyser::add_option(
			 int  short_option ,
			 const std::string &  long_option ,
			 const ref_count_ptr<const Option_Descripter> &  opt )
{
	this -> add_short_option( short_option , opt );
	this -> add_long_option ( long_option  , opt );
}




//
// Flag On
//
void   Option_Analyser::add_short_option_flag_on( int  short_option ,
						  bool *  flag )
{
	this -> add_short_option( short_option ,
				  new Flag_On_Option_Descripter( flag ) );
}

void   Option_Analyser::add_long_option_flag_on
					( const std::string &  long_option ,
					  bool *  flag )
{
	this -> add_long_option( long_option ,
				  new Flag_On_Option_Descripter( flag ) );
}

void   Option_Analyser::add_option_flag_on( int  short_option ,
					    const std::string &  long_option ,
					    bool *  flag )
{
	this -> add_option( short_option , long_option ,
			    new Flag_On_Option_Descripter( flag ) );
}


//
// Flag Off
//
void   Option_Analyser::add_short_option_flag_off( int  short_option ,
						   bool *  flag )
{
	this -> add_short_option( short_option ,
				  new Flag_Off_Option_Descripter( flag ) );
}

void   Option_Analyser::add_long_option_flag_off
					( const std::string &  long_option ,
					  bool *  flag )
{
	this -> add_long_option( long_option ,
				 new Flag_Off_Option_Descripter( flag ) );
}

void   Option_Analyser::add_option_flag_off( int  short_option ,
					     const std::string &  long_option ,
					     bool *  flag )
{
	this -> add_option( short_option , long_option ,
			    new Flag_Off_Option_Descripter( flag ) );
}


//
// Flag Toggle
//
void   Option_Analyser::add_short_option_flag_toggle( int  short_option ,
						      bool *  flag )
{
	this -> add_short_option( short_option ,
				  new Flag_Toggle_Option_Descripter( flag ) );
}

void   Option_Analyser::add_long_option_flag_toggle
					( const std::string &  long_option ,
					  bool *  flag )
{
	this -> add_long_option( long_option ,
				 new Flag_Toggle_Option_Descripter( flag ) );
}

void   Option_Analyser::add_option_flag_toggle
					( int  short_option ,
					  const std::string &  long_option ,
					  bool *  flag )
{
	this -> add_option( short_option , long_option ,
			    new Flag_Toggle_Option_Descripter( flag ) );
}


//
// Flag Integer
//
void   Option_Analyser::add_short_option_integer( int  short_option ,
						  int *  i )
{
	this -> add_short_option( short_option ,
				  new Integer_Option_Descripter( i ) );
}

void   Option_Analyser::add_long_option_integer
					( const std::string &  long_option ,
					  int *  i )
{
	this -> add_long_option( long_option ,
				 new Integer_Option_Descripter( i ) );
}

void   Option_Analyser::add_option_integer( int  short_option ,
					    const std::string &  long_option ,
					    int *  i )
{
	this -> add_option( short_option , long_option ,
			    new Integer_Option_Descripter( i ) );
}


//
// Flag Float
//
void   Option_Analyser::add_short_option_float( int  short_option ,
						double *  d )
{
	this -> add_short_option( short_option ,
				  new Float_Option_Descripter( d ) );
}

void   Option_Analyser::add_long_option_float
					( const std::string &  long_option ,
					  double *  d )
{
	this -> add_long_option( long_option ,
				 new Float_Option_Descripter( d ) );
}

void   Option_Analyser::add_option_float( int  short_option ,
					  const std::string &  long_option ,
					  double *  d )
{
	this -> add_option( short_option , long_option ,
			    new Float_Option_Descripter( d ) );
}


//
// Flag String
//
void   Option_Analyser::add_short_option_string( int  short_option ,
						 std::string *  str )
{
	this -> add_short_option( short_option ,
				  new String_Option_Descripter( str ) );
}

void   Option_Analyser::add_long_option_string
					( const std::string &  long_option ,
					   std::string *  str )
{
	this -> add_long_option( long_option ,
				 new String_Option_Descripter( str ) );
}

void   Option_Analyser::add_option_string( int  short_option ,
					   const std::string &  long_option ,
					   std::string *  str )
{
	this -> add_option( short_option , long_option ,
			    new String_Option_Descripter( str ) );
}
