#ifndef	   OPTION_ANALYSER_H_INCLUDED
#define	   OPTION_ANALYSER_H_INCLUDED

// Author:		H. Shimora
// Created:		Jan 27 2000
// Last-Modified:	Jan 27 2000
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Jan 27 2000    test version.
//
//

#ifdef HAVE_CONFIG_H
# include  "config.h"
#endif

#include  <string>
#include  <map>
#include  <vector>
#include  <cstdlib>
#include  <iostream>
#include  "ref_count_ptr.h"

class  Option_Analyser
{
public:
	class  Option_Descripter
	{
	public:
		virtual	~Option_Descripter() {}

		virtual	int	execute( const std::vector<std::string> & )
									const
		{
			return( 0 );
		}
	};

public:
	class  Flag_On_Option_Descripter : public Option_Descripter
	{
	protected:
		bool *	flag;

	public:
			 Flag_On_Option_Descripter( bool *  f )
				 : flag(f) {}
		virtual	~Flag_On_Option_Descripter() {}

		virtual	int	execute( const std::vector<std::string> & )
									const
		{
			if ( flag )
			{
				*flag = true;
			}

			return( 0 );
		}
	};

	class  Flag_Off_Option_Descripter : public Option_Descripter
	{
	protected:
		bool *	flag;

	public:
			 Flag_Off_Option_Descripter( bool *  f )
				 : flag(f) {}
		virtual	~Flag_Off_Option_Descripter() {}
		virtual	int	execute( const std::vector<std::string> & )
									const
		{
			if ( flag )
			{
				*flag = false;
			}

			return( 0 );
		}
	};

	class  Flag_Toggle_Option_Descripter
		: public Option_Analyser::Option_Descripter
	{
	protected:
		bool *	flag;

	public:
			 Flag_Toggle_Option_Descripter( bool *  f )
				 : flag(f) {}
		virtual	~Flag_Toggle_Option_Descripter() {}

		virtual	int	execute( const std::vector<std::string> & )
									const
		{
			if ( flag )
			{
				*flag = ! *flag;
			}

			return( 0 );
		}
	};

	class  Integer_Option_Descripter
		: public Option_Analyser::Option_Descripter
	{
	protected:
		int *	integer;

	public:
			 Integer_Option_Descripter( int *  i )
				 : integer(i) {}
		virtual	~Integer_Option_Descripter() {}

		virtual	int	execute
				( const std::vector<std::string> &  arg )
									const
		{
			if ( arg.size() < 1 )
			{
				return( -1 );
			}

			if ( integer )
			{
				char *	c;
				long	long_num;
				long_num
				    = std::strtol( arg[0].c_str() , &c , 10 );

				if ( *c != '\0'
				  || long_num == LONG_MIN
				  || long_num == LONG_MAX
				  || long_num < INT_MIN
				  || long_num > INT_MAX )
				{
					std::cerr << "integer number option"
						  << " error ["
						  << arg[0] << "]"
						  << std::endl;

					return( -1 );
				}
				else
				{
					*integer = static_cast<int>(long_num);
				}
			}

			return( 1 );
		}
	};

	class  Float_Option_Descripter
		: public Option_Analyser::Option_Descripter
	{
	protected:
		double *	number;

	public:
			 Float_Option_Descripter( double *  n )
				 : number(n) {}
		virtual	~Float_Option_Descripter() {}

		virtual	int	execute
				( const std::vector<std::string> &  arg )
									const
		{
			if ( arg.size() < 1 )
			{
				return( -1 );
			}

			if ( number )
			{
				char *	c;
				double	dbl_num;
				dbl_num = std::strtod( arg[0].c_str() , &c );

				if ( *c != '\0' )
				{
					std::cerr
					     << "float point number option"
					     << " error [" << arg[0] << "]"
					     << std::endl;

					return( -1 );
				}
				else
				{
					*number = dbl_num;
				}
			}

			return( 1 );
		}
	};

	class  String_Option_Descripter
		: public Option_Analyser::Option_Descripter
	{
	protected:
		std::string *	str;

	public:
			 String_Option_Descripter( std::string *  s )
				 : str(s) {}
		virtual	~String_Option_Descripter() {}

		virtual	int	execute
				( const std::vector<std::string> &  arg )
									const
		{
			if ( arg.size() < 1 )
			{
				return( -1 );
			}

			if ( str )
			{
				*str = arg[0];
			}

			return( 1 );
		}
	};


private:
	std::map< int , ref_count_ptr<const Option_Descripter> >
							short_option_map;

	std::map< std::string , ref_count_ptr<const Option_Descripter> >
							long_option_map;

	std::string			argv_0;
	std::vector< std::string >	rest_options;

	bool				valid;

public:
		 Option_Analyser();
	virtual	~Option_Analyser();

	virtual	bool	analyse( int  argc ,
				 const char *const *const  argv );

	virtual	const std::vector<std::string> &	rest() const;

	virtual	std::string				program_name() const;

	virtual	void	usage( std::ostream &  ostr = std::cerr ) const;

	virtual	bool	check() const;

	virtual	operator  bool() const;

	//
	// Add Option
	//
	virtual	void	add_short_option
			( int  short_option ,
			  const ref_count_ptr<const Option_Descripter> & opt );

	virtual	void	add_long_option
			( const std::string &  long_option ,
			  const ref_count_ptr<const Option_Descripter> & opt );

	virtual	void	add_option
			( int  short_option ,
			  const std::string &  long_option ,
			  const ref_count_ptr<const Option_Descripter> & opt );


	//
	// Add Flag On Option
	//
	virtual	void	add_short_option_flag_on( int  short_option ,
						  bool *  flag );

	virtual	void	add_long_option_flag_on
					( const std::string &  long_option ,
					  bool *  flag );

	virtual	void	add_option_flag_on( int  short_option ,
					    const std::string &  long_option ,
					    bool *  flag );


	//
	// Add Flag On Option
	//
	virtual	void	add_option_flag_off( int  short_option ,
					     const std::string &  long_option ,
					     bool *  flag );

	virtual	void	add_short_option_flag_off( int  short_option ,
						   bool *  flag );

	virtual	void	add_long_option_flag_off
					( const std::string &  long_option ,
					  bool *  flag );

	//
	// Add Flagg Toggle
	//
	virtual	void	add_short_option_flag_toggle( int  short_option ,
						      bool *  flag );

	virtual	void	add_long_option_flag_toggle
					( const std::string &  long_option ,
					  bool *  flag );

	virtual	void	add_option_flag_toggle
					( int  short_option ,
					  const std::string &  long_option ,
					  bool *  flag );

	//
	// Add Flag Integer
	//
	virtual	void	add_short_option_integer( int  short_option ,
						  int *  i );

	virtual	void	add_long_option_integer
					( const std::string &  long_option ,
					  int *  i );

	virtual	void	add_option_integer( int  short_option ,
					    const std::string &  long_option ,
					    int *  i );

	//
	// Add Option Float
	//
	virtual	void	add_short_option_float( int  short_option ,
						double *  d );

	virtual	void	add_long_option_float
					( const std::string &  long_option ,
					  double *  d );

	virtual	void	add_option_float( int  short_option ,
					  const std::string &  long_option ,
					  double *  d );

	//
	// Add Option String
	//
	virtual	void	add_short_option_string( int  short_option ,
						 std::string *  str );

	virtual	void	add_long_option_string
					( const std::string &  long_option ,
					  std::string *  str );

	virtual	void	add_option_string( int  short_option ,
					   const std::string &  long_option ,
					   std::string *  str );
};


#endif	/* OPTION_ANALYSER_H_INCLUDED */
