#ifndef	   TEST_OPTION_ANALYSER_H_INCLUDED
#define	   TEST_OPTION_ANALYSER_H_INCLUDED

// Author:		H. Shimora
// Last-Modified:	Jun  1 2000
// Created:		Jun  1 2000
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Jun  1 2000    base version.
//
//

#include  "option_analyser.h"
#include  <string>

class  Test_Option_Analyser : public Option_Analyser
{
protected:
	bool		fl;
	int		in;
	double		db;
	std::string	st;

public:
	Test_Option_Analyser()
		: fl( false ) , in(0) , db(0.0) , st()
	{
		add_option_flag_on    ( 'f' , "--flag-on"     , &fl );
		add_option_flag_off   ( 'F' , "--flag-off"    , &fl );
		add_option_flag_toggle( 't' , "--flag-toggle" , &fl );
		add_option_integer    ( 'i' , "--integer"     , &in );
		add_option_float      ( 'd' , "--float"       , &db );
		add_option_string     ( 's' , "--string"      , &st );
	}

	virtual	~Test_Option_Analyser()
	{
	}

	virtual	bool	flag() const
	{
		return( fl );
	}

	virtual	int	integer() const
	{
		return( in );
	}

	virtual	double	dbl() const
	{
		return( db );
	}

	virtual	std::string	str() const
	{
		return( st );
	}
};


#endif	/* TEST_OPTION_ANALYSER_H_INCLUDED */
