#ifdef    PROF_STOPWATCH_TEST
#include  "prof_stopwatch.h"
#include  <iostream>
#include  <unistd.h>

int    main( void )
{
	Prof_Stopwatch	s;

	s.start();

	int	sum = 0;
	for( int  i = 0  ;  i <= 100000 ;  i ++ )
	{
		sum += i;
		getpid();
	}

	s.stop();

	std::cout << s.real().usec() << endl;
	std::cout << s.user().usec() << endl;
	std::cout << s.sys().usec() << endl;

	std::cout << s;

	return( 0 );
}
#endif // PROF_STOPWATCH_TEST


#include  "prof_stopwatch.h"
#include  <cstdio>
#include  <iostream>

using namespace std;

Prof_Stopwatch::Prof_Stopwatch()
{
	ru_start.ru_utime.tv_sec  = 0;
	ru_start.ru_utime.tv_usec = 0;
	ru_start.ru_stime.tv_sec  = 0;
	ru_start.ru_stime.tv_usec = 0;

	ru_stop.ru_utime.tv_sec   = 0;
	ru_stop.ru_utime.tv_usec  = 0;
	ru_stop.ru_stime.tv_sec   = 0;
	ru_stop.ru_stime.tv_usec  = 0;
}

Prof_Stopwatch::~Prof_Stopwatch()
{
}

int    Prof_Stopwatch::start()
{
	int	ret = 0;

	if ( ts_start.set_current_time() == -1 )
	{
		ret = -1;
	}

	if ( getrusage( RUSAGE_SELF , &ru_start ) == -1 )
	{
		perror( "getrusage" );
		ret = -1;
	}

	return( ret );
}

int    Prof_Stopwatch::stop()
{
	int	ret = 0;

	if ( getrusage( RUSAGE_SELF , &ru_stop ) == -1 )
	{
		perror( "getrusage" );
		ret = -1;
	}

	if ( ts_stop.set_current_time() == -1 )
	{
		ret = -1;
	}

	return( ret );
}

Time_Stamp::Time_Diff  Prof_Stopwatch::real() const
{
	return( ts_stop - ts_start );
}

Time_Stamp::Time_Diff  Prof_Stopwatch::user() const
{
	Time_Stamp	start_user_time = ru_start.ru_utime;
	Time_Stamp	stop_user_time  = ru_stop .ru_utime;

	return( stop_user_time - start_user_time );
}

Time_Stamp::Time_Diff  Prof_Stopwatch::sys() const
{
	Time_Stamp	start_system_time = ru_start.ru_stime;
	Time_Stamp	stop_system_time  = ru_stop .ru_stime;

	return( stop_system_time - start_system_time );
}

ostream &  operator << ( ostream &  ostrm ,  const Prof_Stopwatch &  s )
{
	ostrm << "real " << s.real().sec_real() << endl;
	ostrm << "user " << s.user().sec_real() << endl;
	ostrm << "sys "  << s.sys().sec_real() << endl;

	return( ostrm );
}
