#ifdef    HEAP_STATUS_TEST
#include  "heap_status.h"
#include  <strstream>

int    main( void )
{
	Heap_Status::report( "start    " );

	int *	p1 = new int;
	int *	p2 = new int;

	Heap_Status::report( "allocated" );

	delete p1;
	delete p2;

	Heap_Status::report( "end      " );

	return( 0 );
}
#endif // HEAP_STATUS_TEST




#include  "heap_status.h"
#include  <cstdio>
#include  <cstdlib>
#include  <cstring>
#include  <cassert>
#include  <iostream>

static	Heap_Status::Heap_Status_Initializer	heap_status_initializer;

unsigned long			Heap_Status::new_count             =  0;
unsigned long			Heap_Status::delete_count          =  0;
Heap_Status::Memory_Info *	Heap_Status::pointer_list          =  NULL;
size_t				Heap_Status::n_pointer_list_entry  =  0;

static	void	beep( void );


//
// Global operator new()
//
void *  operator new ( size_t  size ) throw(std::bad_alloc)
{
	void *	p = malloc( size );
	if ( p )
	{
		memset( p , '*' , size );
	}
	else
	{
		fprintf( stderr ,  "out of memory!!\n" );
		abort();
	}

	// expand for new pointer information.
	if ( Heap_Status::pointer_list )
	{
		if ( (Heap_Status::pointer_list
		      = (Heap_Status::Memory_Info *)
			  realloc( Heap_Status::pointer_list ,
				   sizeof(Heap_Status::Memory_Info)
				   * (Heap_Status::n_pointer_list_entry + 100) ))
		     ==  NULL )
		{
			fprintf( stderr ,  "out of memory!!\n" );
			abort();
		}
	}
	else
	{
		if ( (Heap_Status::pointer_list
		      = (Heap_Status::Memory_Info *)
			  malloc( sizeof(Heap_Status::Memory_Info) * 1 ))
		     ==  NULL )
		{
			fprintf( stderr ,  "out of memory!!\n" );
			abort();
		}
	}

	Heap_Status::pointer_list[Heap_Status::n_pointer_list_entry].memory
		= p;
	Heap_Status::pointer_list[Heap_Status::n_pointer_list_entry].size
		= size;

	Heap_Status::n_pointer_list_entry ++;

	Heap_Status::new_count ++;

	return( p );
}


//
// Global operator delete
//
void    operator delete ( void *  pointer ) throw()
{
	if ( pointer == NULL )
	{
		return;
	}

	Heap_Status::delete_count ++;

	int	indx = Heap_Status::pointer_to_index( pointer );

	if ( indx < 0 )
	{
		fprintf( stderr , "Bad pointer deleted!!\n" );
		beep();
		Heap_Status::output_pointer_list();
		abort();
	}

	assert( Heap_Status::n_pointer_list_entry >= 1 );
	// move last entity to deleting entity space.
	Heap_Status::pointer_list[indx]
	 = Heap_Status::pointer_list[Heap_Status::n_pointer_list_entry - 1];

	Heap_Status::n_pointer_list_entry --;


	free( pointer );
}


Heap_Status::Heap_Status_Initializer::Heap_Status_Initializer()
{
	ios::sync_with_stdio();

	Heap_Status::new_count             =  0;
	Heap_Status::delete_count          =  0;
	Heap_Status::pointer_list          =  NULL;
	Heap_Status::n_pointer_list_entry  =  0;
}


void   Heap_Status::report( const char *  str ,  FILE *  fp )

{
	if ( str )
	{
		fprintf( stderr , "%s : " , str );
	}

	fprintf( fp , "#%ld new - delete(%lu,%lu)\n" ,
		 new_delete_diff() , n_new() , n_delete() );

	fflush( fp );
}


void   Heap_Status::output_pointer_list()
{
	if ( Heap_Status::n_pointer_list_entry == 0 )
	{
		fprintf( stderr ,  "No entry !!\n" );
		return;
	}

	for( size_t  i = 0  ;  i < Heap_Status::n_pointer_list_entry  ;  i ++ )
	{
		fprintf( stderr , "%lu : %p : %lu\n" ,
			 (unsigned long)i ,
			 Heap_Status::pointer_list[i].memory ,
			 (unsigned long)Heap_Status::pointer_list[i].size );
	}
}


void   Heap_Status::reset()
{
	new_count     =  0;
	delete_count  =  0;
}


unsigned long  Heap_Status::n_new()
{
	return( new_count );
}


unsigned long  Heap_Status::n_delete()
{
	return( delete_count );
}


signed long  Heap_Status::new_delete_diff()
{
	return( new_count - delete_count );
}




// private:
int    Heap_Status::pointer_to_index( void *  pointer )
{
	// search pointer and return its index.

	for( size_t  i = 0  ;  i < Heap_Status::n_pointer_list_entry  ;  i ++ )
	{
		if ( pointer == Heap_Status::pointer_list[i].memory )
		{
			// found!!
			return( i );
		}
	}

	// not found!!
	return( -1 );
}




static
void   beep( void )
{
	putc( '\a' ,  stderr );
}
