#ifndef	   REF_COUNT_PTR_H_INCLUDED
#define	   REF_COUNT_PTR_H_INCLUDED

// Author:		H. Shimora
// Last-Modified:	Apr 28 2000
// Version:		0.30

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.10  Dec 28 1998    base version.
//
// version 0.20  Dec 29 1998    separate counter and pointer to entity.
//                              memory allocation reduced.
//
// version 0.30  Apr 28 2000    enable different type substitution.
//
//

#ifdef HAVE_CONFIG_H
# include  "config.h"
#endif


template<class T>
class  ref_count_ptr
{
private:
	template<class U>
	friend class ref_count_ptr;

	typedef  unsigned int  REF_COUNTER_TYPE;

	T *				entity;
	mutable	REF_COUNTER_TYPE *	reference_counter;

private:
	void	detach() throw()
	{
		if ( entity )
		{
			if ( reference_counter == 0 /* NULL */ )
			{
				delete entity;
			}
			else
			{
				if ( (-- (*reference_counter)) == 0 )
				{
					delete entity;
					delete reference_counter;
					entity            = 0 /* NULL */;
					reference_counter = 0 /* NULL */;
				}
			}
		}
	}

	void	substitute( const ref_count_ptr &  ptr ) // throw(bad_alloc)
	{
		if ( (entity = ptr.entity) )
		{
			if ( ptr.reference_counter == 0 /* NULL */ )
			{
				reference_counter = new REF_COUNTER_TYPE( 2 );
				ptr.reference_counter = reference_counter;
			}
			else
			{
				reference_counter = ptr.reference_counter;
				(*reference_counter) ++;
			}
		}
	}

	template<class U>
	void	substitute( const ref_count_ptr<U> &  ptr ) // throw(bad_alloc)
	{
		if ( (entity = ptr.entity) )
		{
			if ( ptr.reference_counter == 0 /* NULL */ )
			{
				reference_counter = new REF_COUNTER_TYPE( 2 );

				ptr.reference_counter = reference_counter;
			}
			else
			{
				reference_counter = ptr.reference_counter;
				(*reference_counter) ++;
			}
		}
	}

public:
	ref_count_ptr() throw()
		: entity( 0 /* NULL */ ) ,
		  reference_counter( 0 /* NULL */ )
	{
	}

#ifdef REF_COUNT_PTR_USE_EXPLICIT
	explicit  ref_count_ptr( const ref_count_ptr &  ptr )
#else
	ref_count_ptr( const ref_count_ptr &  ptr )
#endif
		// throw(bad_alloc)
		: entity( 0 /* NULL */ ) ,
		  reference_counter( 0 /* NULL */ )
	{
		substitute( ptr );
	}

	template<class U>
#ifdef REF_COUNT_PTR_USE_EXPLICIT
	explicit ref_count_ptr( const ref_count_ptr<U> &  ptr )
#else
	ref_count_ptr( const ref_count_ptr<U> &  ptr )
#endif
		// throw(bad_alloc)
		: entity( 0 /* NULL */ ) ,
		  reference_counter( 0 /* NULL */ )
	{
		substitute( ptr );
	}

#ifdef REF_COUNT_PTR_USE_EXPLICIT
	explicit  ref_count_ptr( const T * raw_pointer ) throw()
#else
	ref_count_ptr( const T * raw_pointer ) throw()
#endif
		: entity( const_cast<T*>(raw_pointer) ) ,
		  reference_counter( /* NULL */ )
	{
	}

	~ref_count_ptr() throw()
	{
		detach();
	}

	ref_count_ptr &  operator= ( const ref_count_ptr &  ptr )
		// throw(bad_alloc)
	{
		if ( ptr.entity == this -> entity )
		{
			return( *this );
		}
		else
		{
			detach();

			substitute( ptr );

			return( *this );
		}
	}

	template<class U>
	ref_count_ptr &  operator= ( const ref_count_ptr<U> &  ptr )
		// throw(bad_alloc)
	{
		if ( ptr.entity == this -> entity )
		{
			return( *this );
		}
		else
		{
			detach();

			substitute( ptr );

			return( *this );
		}
	}

	ref_count_ptr &  operator= ( const T *  raw_pointer ) throw()
	{
		detach();

		entity            = const_cast<T*>(raw_pointer);
		reference_counter = 0 /* NULL */;

		return( *this );
	}

	T &  operator* () const throw()
	{
		return( *entity );
	}

	T *operator-> () const throw()
	{
		return( entity );
	}

	operator bool () const throw()
	{
		return( entity != 0 /* NULL */ );
	}

	T *  get() const throw()
	{
		return( entity );
	}
};


#endif	/* REF_COUNT_PTR_H_INCLUDED */
