#ifndef	   TIME_STAMP_H_INCLUDED
#define	   TIME_STAMP_H_INCLUDED

// Author:		H. Shimora
// Last-Modified:	Nov  6 1998
// Version:		0.90

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.90  Nov  6 1998
//
//

extern "C"
{
#if defined(HAVE_CONFIG_H)
#    include "config.h"
#    if defined(TIME_WITH_SYS_TIME) && defined(HAVE_SYS_TIME_H)
#	if TIME_WITH_SYS_TIME
#	    include  <sys/time.h>
#	    include  <time.h>
#	else
#	    if HAVE_SYS_TIME_H
#		include  <sys/time.h>
#	    else
#		include  <time.h>
#	    endif
#	endif
#    else
#       include  <sys/time.h>
#    endif
#else
#    include  <sys/time.h>
#endif
}

class  Time_Stamp
{
protected:
	mutable	time_t	second;
	mutable	long	u_second;

protected:
	const Time_Stamp &	normalize() const;

public:
	class  Time_Diff
	{
	protected:
		time_t	second;
		long	u_second;

	public:
		 Time_Diff( time_t  second = 0 ,  long  u_second = 0 );
		~Time_Diff();

		void	set( time_t  second ,  long  u_second = 0 );

		long	usec() const;
		long	msec() const;
		time_t	sec() const;

		double	usec_real() const;
		double	msec_real() const;
		double	sec_real() const;

		operator double() const;

		Time_Diff	operator + ( const Time_Diff &  t ) const;
		Time_Diff	operator - ( const Time_Diff &  t ) const;

#if 0
		Time_Diff	operator - () const;

		Time_Diff	operator * ( int  n ) const;
		Time_Diff	operator * ( double  n ) const;

		Time_Diff	operator / ( int  n ) const;
		Time_Diff	operator / ( double  n ) const;
#endif
	};


public:
	 Time_Stamp();
	 Time_Stamp( time_t  s ,  long  u = 0 );
	 Time_Stamp( struct timeval  tv );
	~Time_Stamp();

	int	set_current_time();

	time_t	sec() const;
	long	usec() const;

	Time_Stamp	forward_sec ( time_t  second ) const;
	Time_Stamp	forward_msec( long  m_second ) const;
	Time_Stamp	forward_usec( long  u_second ) const;

	Time_Stamp	backward_sec ( time_t  second ) const;
	Time_Stamp	backward_msec( long  m_second ) const;
	Time_Stamp	backward_usec( long  u_second ) const;

	bool		operator == ( const Time_Stamp &  t ) const;
	bool		operator != ( const Time_Stamp &  t ) const;
	bool		operator <  ( const Time_Stamp &  t ) const;
	bool		operator >  ( const Time_Stamp &  t ) const;

	Time_Stamp::Time_Diff	operator - ( const Time_Stamp &  t ) const;
};


#endif	/* TIME_STAMP_H_INCLUDED */
