#ifndef	   UDP_CONNECTION_H_INCLUDED
#define	   UDP_CONNECTION_H_INCLUDED

// Author:		H. Shimora
// Created:		Apr  6 2000
// Last-Modified:	Apr  6 2000
// Version:		0.10

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.10  Apr  6 2000
//
//


#ifdef HAVE_CONFIG_H
# include  "config.h"
#endif

extern "C"
{
	#include  <sys/types.h>
	#include  <sys/socket.h>
	#include  <netinet/in.h>
}

#include  <string>
#include  "ip_address.h"
#include  "time_stamp.h"
#include  "ref_count_ptr.h"

class  UDP_Connection
{
public:
	static	const	int	BAD_FD = (-1);

protected:
	int			sfd;
	struct sockaddr_in	addr;

	Time_Stamp		recv_time;
	bool			received;

	size_t			buffer_size;

	long			max_response;

	bool			debug_flag;

public:
		 UDP_Connection( const std::string &  host ,
				 ip_port_number_t  port_num ,
				 bool  debug ,
				 size_t  buf_size ,
				 long  max_resp );

		 UDP_Connection( ip_port_number_t  port_num ,
				 bool  debug ,
				 size_t  buf_size ,
				 long  max_resp );

	virtual	~UDP_Connection();

	virtual	operator bool() const;
	virtual	bool	responsive() const;

	virtual	int	send( const std::string &  str );

	virtual	int	recv( ref_count_ptr<std::string> *  buf ,
			      bool  block ,  bool  reply = false );

	virtual	int	recv( ref_count_ptr<std::string> *  buf ,
			      long  usec ,  bool  reply = false );

	virtual	int	recv( std::string *  buf ,
			      bool  block ,  bool  reply = false );

	virtual	int	recv( std::string *  buf ,
			      long  usec ,  bool  reply = false );

	virtual	int	recv( ref_count_ptr<char> *  buf ,  bool  append_nul ,
			      bool  block , bool  reply = false );

	virtual	int	recv( ref_count_ptr<char> *  buf ,  bool  append_nul ,
			      long  usec ,  bool  reply = false );

	virtual	int	recv( char *  buf ,  size_t  len ,  bool  append_nul ,
			      long  usec ,  bool  reply = false );

	virtual	int	recv( char *  buf ,  size_t  len ,  bool  append_nul ,
			      bool  block ,  bool  reply = false );

	virtual	int	fd() const;

	virtual	int	close();
};


#endif	/* UDP_CONNECTION_H_INCLUDED */
