#ifndef	   COMMAND_QUEUE_H_INCLUDED
#define	   COMMAND_QUEUE_H_INCLUDED

//
// Command_Queue
//
#include  "soccer_composite_command.h"
#include  "soccer_action.h"
#include  "ref_count_ptr.h"
#include  "field_predicate.h"
#include  <deque>
#include  <stdexcept>

class  Command_Queue : public Soccer_Action
{
public:
	class Empty_Queue_Pop_Exception{};

protected:
	struct  Command_or_Action
	{
		bool	is_command;

		Soccer_Composite_Command	command;
		ref_count_ptr<Soccer_Action>	action;
	};

	class  Internal_Queue_Class : public std::deque<Command_or_Action>
	{
	public:
		void	push( const Command_or_Action &  com_or_act )
		{
			this -> push_back( com_or_act );
		}

		void	pop()
		{
			this -> pop_front();
		}
	};


	mutable	Internal_Queue_Class	q;

protected:
	void	overwrite_this( const Command_Queue & );
	void	remove_finished_action() const;

public:
		 Command_Queue();
		 Command_Queue( const Command_Queue & );
		 Command_Queue( const Soccer_Composite_Command & );
		 Command_Queue( const ref_count_ptr<Soccer_Action> & );
		 Command_Queue( Soccer_Action * );
	virtual	~Command_Queue();

	virtual	Command_Queue &	operator = ( const Command_Queue & );

	virtual	Command_Queue&	push( const Soccer_Composite_Command & );
	virtual	Command_Queue&	push( const ref_count_ptr<Soccer_Action> & );
	virtual	Command_Queue&	push( Soccer_Action * );

	virtual	Command_Queue&	push( const Soccer_Composite_Command & ,
				      const Soccer_Composite_Command & );

	virtual	Soccer_Composite_Command
				pop() throw( Empty_Queue_Pop_Exception );

	virtual	bool				empty() const;

	virtual	void				clear();

	virtual	operator bool() const;


	virtual	Soccer_Composite_Command	action();
	virtual	ref_count_ptr<Soccer_Action>	copy() const;

	virtual	bool				finished() const;
	virtual	bool				succeeded() const;
};


class  Time_Limit_Queue : public Command_Queue
{
protected:
	const Field_Recog_Interface &	f;
	long				time_limit;

public:
		 Time_Limit_Queue( const Field_Recog_Interface &  f ,
				   long  lim );

		 Time_Limit_Queue( const Field_Recog_Interface &  f ,
				   long  lim ,
				   const Soccer_Composite_Command & );

		 Time_Limit_Queue( const Field_Recog_Interface &  f ,
				   long  lim ,
				   const ref_count_ptr<Soccer_Action> & );

		 Time_Limit_Queue( const Field_Recog_Interface &  f ,
				   long  lim ,
				   Soccer_Action * );

	virtual	~Time_Limit_Queue();

	virtual	Soccer_Composite_Command
				pop() throw( Empty_Queue_Pop_Exception );

	virtual	bool		empty() const;

	virtual	void		set_limit( long  lim );

	virtual	long		rest() const;
};


class  Condition_Queue : public Command_Queue
{
protected:
	const Field_Recog_Interface &	f;
	const ref_count_ptr<const Field_Predicate>	predicate;

public:
		 Condition_Queue( const Field_Recog_Interface &  f ,
				  const ref_count_ptr<const Field_Predicate> &
				  predicate
				   = static_cast<const Field_Predicate *>(0) );

		 Condition_Queue( const Field_Recog_Interface &  f ,
				  const ref_count_ptr<const Field_Predicate> &
								    predicate ,
				  const Soccer_Composite_Command & );

		 Condition_Queue( const Field_Recog_Interface &  f ,
				  const ref_count_ptr<const Field_Predicate> &
								    predicate ,
				  const ref_count_ptr<Soccer_Action> & );

		 Condition_Queue( const Field_Recog_Interface &  f ,
				  const ref_count_ptr<const Field_Predicate> &
								    predicate ,
				  Soccer_Action * );

	virtual	~Condition_Queue();

	virtual	bool	operator() ( const Field_Recog_Interface & ) const;

	virtual	bool	empty() const;
};




#if 0
// XXX
class  Endless_Command_Queue : public Command_Queue
{
public:
		 Endless_Command_Queue();
		 Endless_Command_Queue( const Command_Queue & );
		 Endless_Command_Queue( const Soccer_Composite_Command & );
		 Endless_Command_Queue( const ref_count_ptr<Soccer_Action> & );
		 Endless_Command_Queue( Soccer_Action * );
	virtual	~Endless_Command_Queue();

	virtual	Endless_Command_Queue &
				operator = ( const Endless_Command_Queue & );

	virtual	Endless_Command_Queue &
			push( const Soccer_Composite_Command & );

	virtual	Endless_Command_Queue &
			push( const ref_count_ptr<Soccer_Action> & );

	virtual	Endless_Command_Queue &	push( Soccer_Action * );

	virtual	Endless_Command_Queue &
			push( const Soccer_Composite_Command & ,
			      const Soccer_Composite_Command & );

	virtual	Soccer_Composite_Command
				pop() throw( Empty_Queue_Pop_Exception );

	virtual	bool				empty() const;

	virtual	void				clear();

	virtual	operator bool() const;


	virtual	Soccer_Composite_Command	action();
	virtual	ref_count_ptr<Soccer_Action>	copy() const;

	virtual	bool				finished() const;
	virtual	bool				succeeded() const;
};
#else
class  Endless_Command_Queue;
#endif

class  And_Command_Queue;
class  Or_Command_Queue;



//
// Exclusive_Queue_Controler
//
#include  "command_queue.h" // not needed
#include  "soccer_action.h"
#include  "ref_count_ptr.h"
#include  <set>

class  Exclusive_Queue_Controler
{
protected:
	std::set<Command_Queue *>	queue_set;

public:
	 Exclusive_Queue_Controler();
	~Exclusive_Queue_Controler();

	Command_Queue *	register_queue( Command_Queue *  q );


	Command_Queue &	push( Command_Queue &  q ,
			      const Soccer_Composite_Command &  com );

	Command_Queue &	push( Command_Queue &  q ,
			      const Soccer_Composite_Command & com_1 ,
			      const Soccer_Composite_Command & com_2 );

	Command_Queue &	push( Command_Queue &  q ,
			      const ref_count_ptr<Soccer_Action> &  act );

	Command_Queue &	push( Command_Queue &  q ,
			      Soccer_Action *  act );


	const Command_Queue &	clear_other_queues( const Command_Queue &  q );

	void	clear_all_queues();
};


#endif	/* COMMAND_QUEUE_H_INCLUDED */
