#include  "soccer_action.h"

Soccer_Action::Soccer_Action( const Field_Recog_Interface &  f ) throw()
	: fin( false ) , suc( true ) , act_initialized( false ) , f( f )
{
}

Soccer_Action::~Soccer_Action()
{
}

void   Soccer_Action::initialize() const
{
}

bool   Soccer_Action::finished() const
{
	if ( ! act_initialized )
	{
		this -> initialize();
		act_initialized = true;
	}

	return( this -> fin );
}

bool   Soccer_Action::succeeded() const
{
	return( this -> suc );
}


// protected:
void   Soccer_Action::set_finished() throw()
{
	this -> fin = true;
}

// protected:
void   Soccer_Action::set_unfinished() throw()
{
	this -> fin = false;
}


// protected:
void   Soccer_Action::set_succeeded() throw()
{
	this -> suc = true;
}

// protected:
void   Soccer_Action::set_failed() throw()
{
	this -> suc = false;
}

Soccer_Composite_Command  Soccer_Action::get_command()
{
	if ( ! act_initialized )
	{
		this -> initialize();
		act_initialized = true;
	}

	return( this -> action() );
}
