#ifndef	   SOCCER_ACTION_H_INCLUDED
#define	   SOCCER_ACTION_H_INCLUDED

#include  "field_recog_interface.h"
#include  "soccer_composite_command.h"

class  Soccer_Action
{
private:
	bool	fin;
	bool	suc;

	mutable	bool	act_initialized;

protected:
	const Field_Recog_Interface &	f;

	virtual	void	set_finished() throw();
	virtual	void	set_unfinished() throw();

	virtual	void	set_succeeded() throw();
	virtual	void	set_failed() throw();

protected:
	virtual	void	initialize() const;

public:
		 Soccer_Action( const Field_Recog_Interface & ) throw();
	virtual	~Soccer_Action();

	virtual	Soccer_Composite_Command	action() = 0;
	virtual	ref_count_ptr<Soccer_Action>	copy() const = 0;

	virtual	Soccer_Composite_Command	get_command();
	virtual	bool				finished() const;
	virtual	bool				succeeded() const;
};


#endif	/* SOCCER_ACTION_H_INCLUDED */
