#include  "soccer_agent_environment.h"
#include  <iostream>
#include  <cstdio>
#include  <cstdlib>
#include  <cfloat>
#include  <csignal>
#include  <stdexcept>

#if 0
# ifdef __FreeBSD__
# include  <ieeefp.h>
# endif
#endif

using namespace std;


Field_Recog_Interface	Soccer_Agent_Environment::dummy_field_recog;

std::set< ref_count_ptr<SServer_Player_Connection> >
			Soccer_Agent_Environment::server_set;

Soccer_Agent_Environment::Soccer_Agent_Environment
				( const Soccer_Option_Analyser &  opt )
{
	ios::sync_with_stdio();

	cout.precision( DBL_DIG );
	cerr.precision( DBL_DIG );

#if 0
# ifdef __FreeBSD__
	const fp_except_t	fp_mask = (  FP_X_INV | FP_X_OFL  | FP_X_UFL
					   | FP_X_DZ  | FP_X_DNML | FP_X_STK );

	fpresetsticky( fp_mask );

	fpsetmask( fpgetmask() | fp_mask );
# endif
#endif

	try
	{
		this -> valid_flag = true;

		param = new SServer_Param;

		Debug_Stream::dbg.inhibit( opt.debug().inhibit );

		server = new SServer_Player_Connection( *param ,
							opt.hostname() ,
							opt.port_number() );

		if ( ! (*server) )
		{
			cerr << "Illegal server connenction" << endl;

			this -> valid_flag = false;
			return;
		}

		server_set.insert( server );
		if ( signal( SIGHUP  , signal_handler ) == SIG_ERR
		  || signal( SIGINT  , signal_handler ) == SIG_ERR
		  || signal( SIGQUIT , signal_handler ) == SIG_ERR )
		{
			perror( "signal" );

			this -> valid_flag = false;
			return;
		}


		manager = new Soccer_Manager( param , server.get() ,
					      opt.true_view() );

		Game_Info	game_info;
		if ( opt.reconnect() == false )
		{
			if ( manager -> init_connection
			     ( opt.teamname() ,
			       opt.goalie() ,
			       &game_info ,
			       opt.server_major_version() ,
			       opt.server_minor_version() ) == (-1) )
			{
				cerr << "init failed." << endl;

				this -> valid_flag = false;
				return;
			}
		}
		else
		{
			if ( manager -> reconnect_connection
			     ( opt.teamname() ,
			       opt.reconnect_player_number() ,
			       &game_info ) == (-1) )
			{
				cerr << "reconnect failed." << endl;

				this -> valid_flag = false;
				return;
			}
		}

		if ( opt.with_debug_server() )
		{
			debug = new Debug_Client_Connection
				      ( opt.debug_hostname() ,
					opt.debug_port_number() );

			manager -> register_debug_connection( debug.get() );
		}

		field_recog = new Field_Recog( param.get() ,
					       game_info ,
					       opt.goalie() ,
					       opt.true_view() );

		manager -> register_field_recog( field_recog.get() );

		field = new Field_Recog_Interface( field_recog.get() );

		manager -> register_field_recog_interface( field.get() );

		if ( ! opt.coach() )
		{
			manager -> send_command( Soccer_Command::Change_View
						 ( View_Width::Narrow ,
						   View_Quality::High ) ,
						 true );
		}
	}
	catch( const std::exception &  e )
	{
		cerr << "exception caught!! [" << e.what() << "]" << endl;

		this -> valid_flag = false;

		return;
	}
	catch( ... )
	{
		cerr << "exception caught!!" << endl;

		this -> valid_flag = false;

		return;
	}
}

Soccer_Agent_Environment::~Soccer_Agent_Environment()
{
	if ( this -> manager )
	{
		manager -> send_bye();
	}
}

const Field_Recog_Interface &
	Soccer_Agent_Environment::field_recog_interface() const
{
	if ( this -> field )
	{
		return( *field );
	}
	else
	{
		return( dummy_field_recog );
	}
}

void   Soccer_Agent_Environment::set_action
				  ( const ref_count_ptr<Soccer_Action> &  act )
{
	this -> action = act;
}

void   Soccer_Agent_Environment::run()
{
	while( this -> valid() )
	{
		this -> next_step();

		try
		{
			if ( this -> action  &&  ! action -> finished() )
			{
				this -> send_composite_command
					( action -> get_command() );
			}
		}
		catch( const Command_Queue::Empty_Queue_Pop_Exception & )
		{
			cerr << "empty queue popped!!" << endl;

			abort();
		}
	}
}


bool   Soccer_Agent_Environment::valid() const
{
	if ( this -> manager && this -> manager -> game_over() )
	{
		if ( this -> valid_flag )
		{
			cout << "Game is Over" << endl;
		}

		this -> valid_flag = false;
	}
	else if ( this -> manager && this -> manager -> server_no_response() )
	{
		if ( this -> valid_flag )
		{
			cout << "No Server Response" << endl;
		}

		this -> valid_flag = false;
	}

	return( this -> valid_flag );
}

std::vector<int>  Soccer_Agent_Environment::fd_list() const
{
	std::vector<int>	fd;

	if ( server && (*server) )
	{
		fd.push_back( server -> fd() );
	}

	if ( debug && (*debug) )
	{
		fd.push_back( debug -> fd() );
	}

	return( fd );
}


bool   Soccer_Agent_Environment::next_step_ready() const
{
	return( this -> manager -> next_step_ready() );
}

void   Soccer_Agent_Environment::update( bool  block )
{
	return( this -> manager -> update( block ) );
}

void   Soccer_Agent_Environment::next_step()
{
	if ( this -> manager && this -> field )
	{
		// XXX
		if ( this -> field -> have_target_teammate() )
		{
			this -> manager -> set_target_teammate
				( this -> field -> get_target_teammate() );

		}

		// XXX
		if ( this -> field -> have_target_point() )
		{
			this -> manager -> set_target_point
				( this -> field -> get_target_point() );

		}

		// XXX
		if ( this -> field -> have_message() )
		{
			this -> manager -> set_message
				( this -> field -> get_message() );

		}

		this -> manager -> next_step();
	}
}

int    Soccer_Agent_Environment::send_composite_command
			( const Soccer_Composite_Command &  command )

{
	if ( this -> manager )
	{
		return( this -> manager -> send_composite_command( command ) );
	}
	else
	{
		return( -1 );
	}
}

RETSIGTYPE  Soccer_Agent_Environment::signal_handler( int )
{
	for ( std::set< ref_count_ptr<SServer_Player_Connection> >
		      ::iterator it = server_set.begin()  ;
	      it != server_set.end()  ;  it ++ )
	{
		if ( *it )
		{
			(*it) -> send_bye();
		}
	}

	exit( 0 );
}
