#ifndef	   SOCCER_AGENT_ENVIRONMENT_H_INCLUDED
#define	   SOCCER_AGENT_ENVIRONMENT_H_INCLUDED

// Author:		H. Shimora
// Last-Modified:	Jan 14 2001
// Created:		Jan 14 2001
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Jan 14 2001    base version.
//
//

#ifdef HAVE_CONFIG_H
  #include  "config.h"
#endif

#include  "soccer_manager.h"
#include  "sserver_player_connection.h"
#include  "debug_client_connection.h"
#include  "sserver_param.h"
#include  "field_recog.h"
#include  "field_recog_interface.h"
#include  "soccer_option_analyser.h"
#include  "soccer_action.h"
#include  "command_queue.h"
#include  "debugstream.h"
#include  "ref_count_ptr.h"
#include  <set>
#include  <vector>

#ifndef RETSIGTYPE
  typedef void RETSIGTYPE;
#endif

class  Soccer_Agent_Environment
{
protected:
	mutable	bool					valid_flag;

	ref_count_ptr<SServer_Param>			param;
	ref_count_ptr<SServer_Player_Connection>	server;
	ref_count_ptr<Soccer_Manager>			manager;
	ref_count_ptr<Debug_Client_Connection>		debug;
	ref_count_ptr<Field_Recog>			field_recog;
	ref_count_ptr<Field_Recog_Interface>		field;
	ref_count_ptr<Soccer_Action>			action;

protected:
	static	Field_Recog_Interface			dummy_field_recog;

protected:
	static	RETSIGTYPE				signal_handler( int );
	static	std::set< ref_count_ptr<SServer_Player_Connection> >
							server_set;

public:
	// validity check
	virtual	bool	valid() const;


	// get file descripter set
	virtual	std::vector<int>	fd_list() const;


	// manually update state
	virtual	bool	next_step_ready() const;

	// manually update
	virtual	void	update( bool  block );


	// forward time including auto update state
	virtual	void	next_step();


	// command sending
	virtual	int	send_composite_command
			( const Soccer_Composite_Command &  command );

public:
		 Soccer_Agent_Environment( const Soccer_Option_Analyser & );
	virtual	~Soccer_Agent_Environment();

	virtual	const Field_Recog_Interface &	field_recog_interface() const;

	virtual	void	set_action( const ref_count_ptr<Soccer_Action> & );

	virtual	void	run();
};


#endif	/* SOCCER_AGENT_ENVIRONMENT_H_INCLUDED */
